/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class NanoLessCustomizationExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).parser((Parser)new DefaultParser()).build();
            Path jnanorcPath = NanoLessCustomizationExample.createJnanorcFile();
            Path jlessrcPath = NanoLessCustomizationExample.createJlessrcFile();
            terminal.writer().println("Nano and Less Customization Example");
            terminal.writer().println("----------------------------------");
            terminal.writer().println("jnanorc file: " + jnanorcPath);
            terminal.writer().println("jlessrc file: " + jlessrcPath);
            terminal.writer().println();
            terminal.writer().println("To use nano with this configuration:");
            terminal.writer().println("  nano -rcfile " + jnanorcPath + " filename.txt");
            terminal.writer().println();
            terminal.writer().println("To use less with this configuration:");
            terminal.writer().println("  less -f " + jlessrcPath + " filename.txt");
            terminal.writer().println();
            Path sampleFile = NanoLessCustomizationExample.createSampleFile();
            terminal.writer().println("Sample file created: " + sampleFile);
            terminal.writer().println();
            terminal.writer().println("Press Enter to exit...");
            terminal.reader().read();
            terminal.writer().println("Goodbye!");
            terminal.writer().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Path createJnanorcFile() throws IOException {
        String nanorcContent = "# JLine nano configuration file\nset tabstospaces\nset autoindent\nset tempfile\nset historylog search.log\n\n# Include syntax highlighting files\ninclude /usr/share/nano/*.nanorc\n\n# Use theme system\ntheme example-theme.nanorctheme\n";
        Path nanorcFile = Paths.get("jnanorc", new String[0]);
        Files.write(nanorcFile, nanorcContent.getBytes(), new OpenOption[0]);
        return nanorcFile;
    }

    private static Path createJlessrcFile() throws IOException {
        String lessrcContent = "# JLine less configuration file\nset casesearch\nset autoindent\nset historylog search.log\n\n# Include syntax highlighting files\ninclude /usr/share/nano/*.nanorc\n\n# Use theme system\ntheme example-theme.nanorctheme\n";
        Path lessrcFile = Paths.get("jlessrc", new String[0]);
        Files.write(lessrcFile, lessrcContent.getBytes(), new OpenOption[0]);
        return lessrcFile;
    }

    private static Path createSampleFile() throws IOException {
        String sampleContent = "// Sample Java file for nano and less customization\n\n/**\n * This is a sample class to demonstrate syntax highlighting\n */\npublic class SampleClass {\n    // Constants\n    private static final int MAX_COUNT = 100;\n    \n    // Instance variables\n    private String name;\n    private int count;\n    private boolean active;\n    \n    /**\n     * Constructor\n     */\n    public SampleClass(String name) {\n        this.name = name;\n        this.count = 0;\n        this.active = true;\n    }\n    \n    // TODO: Add more methods\n    \n    /**\n     * Main method\n     */\n    public static void main(String[] args) {\n        SampleClass sample = new SampleClass(\"Test\");\n        System.out.println(\"Created: \" + sample.name);\n        \n        // Loop example\n        for (int i = 0; i < 5; i++) {\n            System.out.println(\"Count: \" + i);\n        }\n    }\n}\n";
        Path sampleFile = Paths.get("SampleClass.java", new String[0]);
        Files.write(sampleFile, sampleContent.getBytes(), new OpenOption[0]);
        return sampleFile;
    }
}

