/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class NonBlockingLineReaderExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader lineReader = LineReaderBuilder.builder().terminal(terminal).build();
        AtomicBoolean running = new AtomicBoolean(true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                while (running.get()) {
                    terminal.writer().print(".");
                    terminal.writer().flush();
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                terminal.writer().println("Error in background task: " + e.getMessage());
                terminal.writer().flush();
            }
        });
        try {
            while (running.get()) {
                try {
                    String line = lineReader.readLine("\nprompt> ");
                    if ("exit".equalsIgnoreCase(line)) {
                        running.set(false);
                        continue;
                    }
                    terminal.writer().println("You entered: " + line);
                    terminal.writer().flush();
                }
                catch (UserInterruptException e) {
                    running.set(false);
                }
            }
            return;
        }
        finally {
            executor.shutdownNow();
            try {
                executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            terminal.writer().println("\nExiting...");
            terminal.close();
        }
    }
}

