/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.NonBlockingReader;

public class NonBlockingReaderExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        NonBlockingReader reader = terminal.reader();
        terminal.writer().println("Type something (program will exit after 10 seconds):");
        terminal.writer().flush();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 10000L) {
            try {
                if (reader.available() > 0) {
                    int c = reader.read();
                    terminal.writer().println("Read character: " + (char)c);
                    terminal.writer().flush();
                }
                terminal.writer().print(".");
                terminal.writer().flush();
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        terminal.writer().println("\nTime's up!");
        terminal.close();
    }
}

