/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

public class PicocliJLineExample {
    public static void main(String[] args) {
        try {
            String line;
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            MyCommand myCommand = new MyCommand(terminal);
            CommandLine cmd = new CommandLine((Object)myCommand);
            while (!(line = reader.readLine("example> ")).equalsIgnoreCase("exit") && !line.equalsIgnoreCase("quit")) {
                try {
                    ParsedLine pl = reader.getParser().parse(line, 0);
                    String[] arguments = pl.words().toArray(new String[0]);
                    cmd.execute(arguments);
                }
                catch (Exception e) {
                    terminal.writer().println("Error: " + e.getMessage());
                    terminal.flush();
                }
            }
            terminal.writer().println("Goodbye!");
            terminal.close();
        }
        catch (IOException e) {
            System.err.println("Error creating terminal: " + e.getMessage());
        }
    }

    @CommandLine.Command(name="example", mixinStandardHelpOptions=true, version={"1.0"}, description={"Example command using JLine and Picocli"})
    static class MyCommand
    implements Callable<Integer> {
        private final Terminal terminal;
        @CommandLine.Option(names={"-c", "--count"}, description={"Number of times to repeat"})
        private int count = 1;
        @CommandLine.Parameters(index="0", description={"The message to display"})
        private String message;

        public MyCommand(Terminal terminal) {
            this.terminal = terminal;
        }

        @Override
        public Integer call() {
            if (this.message == null) {
                this.terminal.writer().println("No message provided. Use --help for usage information.");
            } else {
                for (int i = 0; i < this.count; ++i) {
                    this.terminal.writer().println(this.message);
                }
            }
            this.terminal.flush();
            return 0;
        }
    }
}

