/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.jline.builtins.ssh.Ssh;
import org.jline.builtins.telnet.Telnet;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class RemoteTerminalExample {
    public static void startTelnetServer() throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        Telnet.ShellProvider shellProvider = (clientTerminal, environment) -> {
            try {
                String line;
                LineReader reader = LineReaderBuilder.builder().terminal(clientTerminal).build();
                while ((line = reader.readLine("telnet> ")) != null && !"exit".equals(line)) {
                    clientTerminal.writer().println("You typed: " + line);
                    clientTerminal.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Telnet telnet = new Telnet(terminal, shellProvider);
        telnet.telnetd(new String[]{"--port=2023", "--ip=127.0.0.1", "start"});
    }

    public static void startSshServer() throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        Consumer<Ssh.ShellParams> shellConsumer = params -> {
            try {
                String line;
                Terminal clientTerminal = params.getTerminal();
                LineReader reader = LineReaderBuilder.builder().terminal(clientTerminal).build();
                while ((line = reader.readLine("ssh> ")) != null && !"exit".equals(line)) {
                    clientTerminal.writer().println("You typed: " + line);
                    clientTerminal.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Ssh ssh = new Ssh(shellConsumer, null, () -> {
            SshServer server = SshServer.setUpDefaultServer();
            server.setPasswordAuthenticator((username, password, session) -> "admin".equals(username) && "password".equals(password));
            server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            return server;
        }, null);
        ssh.sshd(System.out, System.err, new String[]{"--port=2222", "--ip=127.0.0.1", "start"});
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && "telnet".equals(args[0])) {
            RemoteTerminalExample.startTelnetServer();
            System.out.println("Telnet server started on port 2023");
            System.out.println("Connect with: telnet localhost 2023");
            System.out.println("Press Ctrl+C to exit");
            Thread.sleep(Long.MAX_VALUE);
        } else if (args.length > 0 && "ssh".equals(args[0])) {
            RemoteTerminalExample.startSshServer();
            System.out.println("SSH server started on port 2222");
            System.out.println("Connect with: ssh -p 2222 admin@localhost");
            System.out.println("Password: password");
            System.out.println("Press Ctrl+C to exit");
            Thread.sleep(Long.MAX_VALUE);
        } else {
            System.out.println("Usage: RemoteTerminalExample [telnet|ssh]");
        }
    }

    public static class RemoteShell
    implements Telnet.ShellProvider {
        public void shell(Terminal terminal, Map<String, String> environment) {
            try {
                String line;
                LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
                terminal.writer().println("Welcome to JLine Remote Shell!");
                terminal.writer().println("Type 'help' for available commands.");
                terminal.writer().println("Type 'exit' to disconnect.");
                terminal.flush();
                while ((line = reader.readLine("shell> ")) != null) {
                    try {
                        if (line.trim().isEmpty()) continue;
                        if ("exit".equals(line)) break;
                        if ("help".equals(line)) {
                            terminal.writer().println("Available commands:");
                            terminal.writer().println("  help - Display this help");
                            terminal.writer().println("  info - Display terminal info");
                            terminal.writer().println("  exit - Exit the shell");
                        } else if ("info".equals(line)) {
                            terminal.writer().println("Terminal type: " + terminal.getType());
                            terminal.writer().println("Size: " + terminal.getWidth() + "x" + terminal.getHeight());
                            terminal.writer().println("Encoding: " + terminal.encoding());
                        } else {
                            terminal.writer().println("Unknown command: " + line);
                            terminal.writer().println("Type 'help' for available commands.");
                        }
                    }
                    catch (Exception e) {
                        terminal.writer().println("Error: " + e.getMessage());
                    }
                    terminal.flush();
                }
                terminal.writer().println("Goodbye!");
                terminal.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

