/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class SimpleLineReadingExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            String prompt = "jline> ";
            while (true) {
                String line = null;
                try {
                    line = reader.readLine(prompt);
                    System.out.println("You entered: " + line);
                    if (!"exit".equalsIgnoreCase(line)) continue;
                }
                catch (UserInterruptException e) {
                    System.out.println("KeyboardInterrupt (Ctrl+C)");
                    continue;
                }
                catch (EndOfFileException e) {
                    System.out.println("End of file (Ctrl+D)");
                    return;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

