/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.nio.file.Paths;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TabCompletionExample {
    public static void main(String[] args) throws IOException {
        StringsCompleter completer = new StringsCompleter(new String[]{"help", "exit", "list", "version"});
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)completer).build();
        System.out.println("Type a command and press Tab to see completions");
        String line = reader.readLine("prompt> ");
        System.out.println("You entered: " + line);
        ArgumentCompleter argCompleter = new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"open", "close", "save"}), new Completers.FilesCompleter(Paths.get(System.getProperty("user.dir"), new String[0]))});
        LineReader argReader = LineReaderBuilder.builder().terminal(terminal).completer((Completer)argCompleter).build();
        System.out.println("Type 'open', 'close', or 'save' followed by a file path");
        System.out.println("Press Tab to complete the file path");
        String command = argReader.readLine("command> ");
        System.out.println("You entered: " + command);
    }
}

