/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TerminalAttributesExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        Attributes attributes = terminal.getAttributes();
        terminal.writer().println("Terminal attributes:");
        terminal.writer().printf("  ECHO: %b%n", attributes.getLocalFlag(Attributes.LocalFlag.ECHO));
        terminal.writer().printf("  ICANON: %b%n", attributes.getLocalFlag(Attributes.LocalFlag.ICANON));
        terminal.writer().printf("  INTR char: %c%n", Character.valueOf((char)attributes.getControlChar(Attributes.ControlChar.VINTR)));
        terminal.writer().flush();
        Attributes raw = new Attributes(attributes);
        raw.setLocalFlag(Attributes.LocalFlag.ECHO, false);
        raw.setLocalFlag(Attributes.LocalFlag.ICANON, false);
        raw.setInputFlag(Attributes.InputFlag.ICRNL, false);
        raw.setControlChar(Attributes.ControlChar.VMIN, 1);
        raw.setControlChar(Attributes.ControlChar.VTIME, 0);
        terminal.setAttributes(raw);
        terminal.writer().println("Switched to raw mode. Press 'q' to exit.");
        terminal.writer().flush();
        int c = terminal.reader().read();
        terminal.setAttributes(attributes);
        terminal.writer().printf("You pressed: %c%n", Character.valueOf((char)c));
        terminal.writer().println("Restored original attributes.");
        terminal.writer().flush();
        terminal.close();
    }
}

