/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class ThemeSystemExample {
    public static void main(String[] args) {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
            Path themeFile = ThemeSystemExample.createThemeFile();
            Path syntaxFile = ThemeSystemExample.createSyntaxFile();
            HashMap<String, AttributedStyle> themeMap = new HashMap<String, AttributedStyle>();
            themeMap.put("BOOLEAN", AttributedStyle.DEFAULT.foreground(7));
            themeMap.put("NUMBER", AttributedStyle.DEFAULT.foreground(4));
            themeMap.put("CONSTANT", AttributedStyle.DEFAULT.foreground(3));
            themeMap.put("COMMENT", AttributedStyle.DEFAULT.foreground(8));
            themeMap.put("STRING", AttributedStyle.DEFAULT.foreground(2));
            terminal.writer().println("Theme System Example");
            terminal.writer().println("-------------------");
            terminal.writer().println("Theme file: " + themeFile);
            terminal.writer().println("Syntax file: " + syntaxFile);
            terminal.writer().println();
            terminal.writer().println("Theme Styles:");
            for (Map.Entry entry : themeMap.entrySet()) {
                AttributedStringBuilder asb = new AttributedStringBuilder();
                asb.append((CharSequence)"  ");
                asb.append((CharSequence)entry.getKey(), (AttributedStyle)entry.getValue());
                asb.append((CharSequence)": ");
                asb.styled((AttributedStyle)entry.getValue(), (CharSequence)"This is styled text");
                terminal.writer().println(asb.toAttributedString());
            }
            terminal.writer().println();
            terminal.writer().println("Sample Styled Text:");
            String sampleCode = "// This is a comment\npublic class Example {\n    public static void main(String[] args) {\n        boolean flag = true;\n        int number = 42;\n        System.out.println(\"Hello, World!\");\n    }\n}\n";
            for (String line : sampleCode.split("\n")) {
                String after;
                String before;
                AttributedStringBuilder asb = new AttributedStringBuilder();
                if (line.trim().startsWith("//")) {
                    asb.styled((AttributedStyle)themeMap.get("COMMENT"), (CharSequence)line);
                } else if (line.contains("true")) {
                    before = line.substring(0, line.indexOf("true"));
                    String keyword = "true";
                    after = line.substring(line.indexOf("true") + 4);
                    asb.append((CharSequence)before);
                    asb.styled((AttributedStyle)themeMap.get("BOOLEAN"), (CharSequence)keyword);
                    asb.append((CharSequence)after);
                } else if (line.contains("42")) {
                    before = line.substring(0, line.indexOf("42"));
                    String number = "42";
                    after = line.substring(line.indexOf("42") + 2);
                    asb.append((CharSequence)before);
                    asb.styled((AttributedStyle)themeMap.get("NUMBER"), (CharSequence)number);
                    asb.append((CharSequence)after);
                } else if (line.contains("\"Hello, World!\"")) {
                    before = line.substring(0, line.indexOf("\"Hello, World!\""));
                    String string = "\"Hello, World!\"";
                    after = line.substring(line.indexOf("\"Hello, World!\"") + 15);
                    asb.append((CharSequence)before);
                    asb.styled((AttributedStyle)themeMap.get("STRING"), (CharSequence)string);
                    asb.append((CharSequence)after);
                } else {
                    asb.append((CharSequence)line);
                }
                terminal.writer().println(asb.toAttributedString());
            }
            terminal.writer().flush();
            terminal.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Path createThemeFile() throws IOException {
        String themeContent = "# Theme system configuration file\nBOOLEAN     brightwhite\nNUMBER      blue\nCONSTANT    yellow\nCOMMENT     brightblack\nDOC_COMMENT white\nTODO        brightwhite,yellow\nWHITESPACE  ,green\nSTRING      green\nKEYWORD     brightblue\nTYPE        cyan\nIDENTIFIER  white\nOPERATOR    red\n#\n# mixin\n#\n+LINT   WHITESPACE: \"[[:space:]]+$\" \\n WHITESPACE: \"\\t*\"\n#\n# parser\n#\n$LINE_COMMENT   COMMENT \\n TODO: \"(FIXME|TODO|XXX)\"\n$BLOCK_COMMENT  COMMENT \\n DOC_COMMENT: startWith=/** \\n TODO: \"(FIXME|TODO|XXX)\"\n";
        Path themeFile = Paths.get("example-theme.nanorctheme", new String[0]);
        Files.write(themeFile, themeContent.getBytes(), new OpenOption[0]);
        return themeFile;
    }

    private static Path createSyntaxFile() throws IOException {
        String syntaxContent = "# Syntax file for Java\nsyntax \"java\" \"\\.java$\"\n\n# Keywords\nKEYWORD: \"\\b(abstract|assert|break|case|catch|class|const|continue|default|do|else|enum|extends|final|finally|for|goto|if|implements|import|instanceof|interface|native|new|package|private|protected|public|return|static|strictfp|super|switch|synchronized|this|throw|throws|transient|try|volatile|while)\\b\"\n\n# Types\nTYPE: \"\\b(boolean|byte|char|double|float|int|long|short|void)\\b\"\n\n# Boolean and null literals\nBOOLEAN: \"\\b(true|false|null)\\b\"\n\n# Numbers\n~NUMBER: \"\\b([0-9]+)\\b\" \"\\b0x[0-9a-fA-F]+\\b\"\n\n# String literals\nSTRING: \"\\\".*?\\\"\" \"'.*?'\"\n\n# Constants\nCONSTANT: \"\\b[A-Z]+([_]{1}[A-Z]+){0,}\\b\"\n\n# Comments\n$LINE_COMMENT: \"//\"\n$BLOCK_COMMENT: \"/*, */\"\n\n# Include the LINT mixin\n+LINT\n";
        Path syntaxFile = Paths.get("java.nanorc", new String[0]);
        Files.write(syntaxFile, syntaxContent.getBytes(), new OpenOption[0]);
        return syntaxFile;
    }
}

