/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class UnicodeInputExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().encoding("UTF-8").build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        terminal.writer().println("Unicode Input Example");
        terminal.writer().println("Try typing Unicode characters like:");
        terminal.writer().println("  \u2022 Emoji: \ud83d\ude00 \ud83d\ude80 \ud83c\udf0d \ud83c\udf89");
        terminal.writer().println("  \u2022 Math symbols: \u03c0 \u2211 \u221a \u221e");
        terminal.writer().println("  \u2022 International characters: \u00e9 \u00f1 \u4f60\u597d \u3053\u3093\u306b\u3061\u306f");
        terminal.writer().println();
        String line = reader.readLine("unicode> ");
        terminal.writer().println("You entered: " + line);
        terminal.writer().println("\nCharacter information:");
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            terminal.writer().printf("  Position %d: '%c' (Unicode: U+%04X)%n", i, Character.valueOf(c), (int)c);
        }
        terminal.close();
    }
}

