/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.examples;

import java.io.IOException;
import org.jline.keymap.KeyMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class WidgetChainExample {
    public static void main(String[] args) throws IOException {
        Terminal terminal = TerminalBuilder.builder().build();
        LineReader reader = LineReaderBuilder.builder().terminal(terminal).build();
        Widget formatTextWidget = () -> {
            reader.callWidget("beginning-of-line");
            reader.callWidget("capitalize-word");
            reader.callWidget("end-of-line");
            String buffer = reader.getBuffer().toString();
            if (!buffer.endsWith(".")) {
                reader.getBuffer().write((CharSequence)".");
            }
            return true;
        };
        Widget quoteTextWidget = () -> {
            String buffer = reader.getBuffer().toString();
            reader.callWidget("beginning-of-line");
            reader.callWidget("kill-line");
            reader.getBuffer().write((CharSequence)("\"" + buffer + "\""));
            return true;
        };
        reader.getWidgets().put("format-text", formatTextWidget);
        reader.getWidgets().put("quote-text", quoteTextWidget);
        KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
        keyMap.bind((Object)formatTextWidget, (CharSequence)KeyMap.alt((char)'f'));
        keyMap.bind((Object)quoteTextWidget, (CharSequence)KeyMap.alt((char)'q'));
        terminal.writer().println("Widget Chain Example");
        terminal.writer().println("  Alt+F: Format text (capitalize first word and add period)");
        terminal.writer().println("  Alt+Q: Quote text (wrap in double quotes)");
        terminal.writer().println();
        String line = reader.readLine("chain> ");
        terminal.writer().println("You entered: " + line);
        terminal.close();
    }
}

