/*
 * Decompiled with CFR 0.152.
 */
package org.jline.demo.graal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import org.jline.builtins.ConfigurationPath;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.OSUtils;
import org.jline.widget.TailTipWidgets;

public class Graal {
    public static void main(String[] args) {
        try {
            Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedQuote(true);
            parser.setEscapeChars(null);
            parser.setRegexVariable(null);
            Terminal terminal = TerminalBuilder.builder().build();
            Thread executeThread = Thread.currentThread();
            terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
            File file = new File(Graal.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String root = file.getCanonicalPath();
            root = root.substring(0, root.length() - 6);
            ConfigurationPath configPath = new ConfigurationPath(Paths.get(root, new String[0]), Paths.get(root, new String[0]));
            HashSet<Builtins.Command> commands = new HashSet<Builtins.Command>(Arrays.asList(Builtins.Command.values()));
            commands.remove(Builtins.Command.TTOP);
            Builtins builtins = new Builtins(commands, workDir, configPath, null);
            SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, workDir, configPath);
            systemRegistry.setCommandRegistries(new CommandRegistry[]{builtins});
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).variable("list-max", (Object)100).variable("history-file", (Object)Paths.get(root, "history")).option(LineReader.Option.INSERT_BRACKET, true).option(LineReader.Option.EMPTY_WORD_OPTIONS, false).option(LineReader.Option.USE_FORWARD_SLASH, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).build();
            if (OSUtils.IS_WINDOWS) {
                reader.setVariable("blink-matching-paren", (Object)0);
            }
            builtins.setLineReader(reader);
            new TailTipWidgets(reader, arg_0 -> ((SystemRegistryImpl)systemRegistry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            System.out.println(terminal.getName() + ": " + terminal.getType());
            while (true) {
                try {
                    while (true) {
                        systemRegistry.cleanUp();
                        String line = reader.readLine("graal> ");
                        Object result = systemRegistry.execute(line);
                        if (result == null) continue;
                        System.out.println(result);
                    }
                }
                catch (UserInterruptException line) {
                    continue;
                }
                catch (EndOfFileException e) {
                }
                catch (Exception e) {
                    systemRegistry.trace(true, e);
                    continue;
                }
                break;
            }
            systemRegistry.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

