/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.console.ui.Console;
import groovy.console.ui.ObjectBrowser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.console.AbstractCommandRegistry;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.Printer;
import org.jline.groovy.ObjectInspector;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyEngine;
import org.jline.utils.AttributedString;

public class GroovyCommand
extends AbstractCommandRegistry
implements CommandRegistry {
    private GroovyEngine engine;
    private Printer printer;
    private final Map<Command, CmdDesc> commandDescs = new HashMap<Command, CmdDesc>();
    private final Map<Command, List<String>> commandInfos = new HashMap<Command, List<String>>();
    private boolean consoleUi;
    private boolean ivy;

    public GroovyCommand(GroovyEngine engine, Printer printer) {
        this(null, engine, printer);
    }

    public GroovyCommand(Set<Command> commands, GroovyEngine engine, Printer printer) {
        this.engine = engine;
        this.printer = printer;
        try {
            Class.forName("groovy.console.ui.ObjectBrowser");
            this.consoleUi = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("org.apache.ivy.util.Message");
            System.setProperty("groovy.grape.report.downloads", "true");
            this.ivy = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<Object> cmds = new HashSet();
        HashMap<Command, String> commandName = new HashMap<Command, String>();
        HashMap<Command, CommandMethods> commandExecute = new HashMap<Command, CommandMethods>();
        cmds = commands == null ? new HashSet<Command>(EnumSet.allOf(Command.class)) : new HashSet<Command>(commands);
        if (!this.consoleUi) {
            cmds.remove((Object)Command.CONSOLE);
        }
        if (!this.ivy) {
            cmds.remove((Object)Command.GRAB);
        }
        for (Command c : cmds) {
            commandName.put(c, c.name().toLowerCase());
        }
        commandExecute.put(Command.INSPECT, new CommandMethods(this::inspect, this::inspectCompleter));
        commandExecute.put(Command.CONSOLE, new CommandMethods(this::console, this::defaultCompleter));
        commandExecute.put(Command.GRAB, new CommandMethods(this::grab, this::grabCompleter));
        this.registerCommands(commandName, commandExecute);
        this.commandDescs.put(Command.INSPECT, this.inspectCmdDesc());
        this.commandDescs.put(Command.CONSOLE, this.consoleCmdDesc());
        this.commandDescs.put(Command.GRAB, this.grabCmdDesc());
    }

    public List<String> commandInfo(String command) {
        Command cmd = (Command)((Object)this.registeredCommand(command));
        return this.commandInfos.get((Object)cmd);
    }

    public CmdDesc commandDescription(String command) {
        Command cmd = (Command)((Object)this.registeredCommand(command));
        return this.commandDescs.get((Object)cmd);
    }

    public Object grab(CommandInput input) {
        if (input.args().length != 1) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        try {
            String arg = input.args()[0];
            if (arg.equals("-?") || arg.equals("--help")) {
                this.printer.println((Object)this.helpDesc(Command.GRAB));
            } else if (arg.equals("-l") || arg.equals("--list")) {
                Object resp = this.engine.execute("groovy.grape.Grape.getInstance().enumerateGrapes()");
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("skipDefaultOptions", true);
                options.put("maxDepth", 1);
                options.put("indention", 4);
                options.put("valueStyle", "classpath:/org/jline/groovy/gron.nanorc");
                this.printer.println(options, resp);
            } else {
                if (arg.startsWith("-")) {
                    throw new IllegalArgumentException("Unknown command option: " + arg);
                }
                Map<String, String> artifact = new HashMap();
                Object xarg = input.xargs()[0];
                if (xarg instanceof String) {
                    String[] vals = input.args()[0].split(":");
                    if (vals.length != 3) {
                        throw new IllegalArgumentException("Invalid command parameter: " + input.args()[0]);
                    }
                    artifact.put("group", vals[0]);
                    artifact.put("module", vals[1]);
                    artifact.put("version", vals[2]);
                } else if (xarg instanceof Map) {
                    artifact = (Map)xarg;
                } else {
                    throw new IllegalArgumentException("Unknown command parameter: " + xarg);
                }
                this.engine.put("_artifact", artifact);
                this.engine.execute("groovy.grape.Grape.grab(_artifact)");
            }
        }
        catch (Exception e) {
            this.saveException(e);
        }
        return null;
    }

    public void console(CommandInput input) {
        if (input.args().length > 1) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        if (input.args().length == 1) {
            String arg = input.args()[0];
            if (arg.equals("-?") || arg.equals("--help")) {
                this.printer.println((Object)this.helpDesc(Command.CONSOLE));
                return;
            }
            throw new IllegalArgumentException("Unknown command parameter: " + input.args()[0]);
        }
        Console c = new Console(this.engine.sharedData);
        c.run();
    }

    public Object inspect(CommandInput input) {
        String option;
        if (input.xargs().length == 0) {
            return null;
        }
        if (input.args().length > 2) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        int idx = this.optionIdx(Command.INSPECT, input.args());
        String string = option = idx < 0 ? "--info" : input.args()[idx];
        if (option.equals("-?") || option.equals("--help")) {
            this.printer.println((Object)this.helpDesc(Command.INSPECT));
            return null;
        }
        int id = 0;
        if (idx >= 0) {
            int n = id = idx == 0 ? 1 : 0;
        }
        if (input.args().length < id + 1) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        try {
            Object obj = input.xargs()[id];
            ObjectInspector inspector = new ObjectInspector(obj);
            Object out = null;
            if (option.equals("-m") || option.equals("--methods")) {
                out = inspector.methods();
            } else if (option.equals("-n") || option.equals("--metaMethods")) {
                out = inspector.metaMethods();
            } else if (option.equals("-i") || option.equals("--info")) {
                out = inspector.properties();
            } else if (this.consoleUi && (option.equals("-g") || option.equals("--gui"))) {
                ObjectBrowser.inspect((Object)obj);
            } else {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("skipDefaultOptions", true);
            options.put("columns", ObjectInspector.METHOD_COLUMNS);
            options.put("maxDepth", 1);
            options.put("indention", 4);
            options.put("valueStyle", "classpath:/org/jline/groovy/gron.nanorc");
            this.printer.println(options, out);
        }
        catch (Exception e) {
            this.saveException(e);
        }
        return null;
    }

    private CmdDesc helpDesc(Command command) {
        return this.doHelpDesc(command.toString().toLowerCase(), this.commandInfos.get((Object)command), this.commandDescs.get((Object)command));
    }

    private CmdDesc grabCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        optDescs.put("-l --list", this.doDescription("List the modules in the cache"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Add maven repository dependencies to classpath");
        this.commandInfos.put(Command.GRAB, info);
        mainDesc.add(new AttributedString((CharSequence)"grab <group>:<artifact>:<version>"));
        mainDesc.add(new AttributedString((CharSequence)"grab --list"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private CmdDesc consoleCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Launch Groovy console");
        this.commandInfos.put(Command.CONSOLE, info);
        mainDesc.add(new AttributedString((CharSequence)"console"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private CmdDesc inspectCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        if (this.consoleUi) {
            optDescs.put("-g --gui", this.doDescription("Launch object browser"));
        }
        optDescs.put("-i --info", this.doDescription("Object class info"));
        optDescs.put("-m --methods", this.doDescription("List object methods"));
        optDescs.put("-n --metaMethods", this.doDescription("List object metaMethods"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Display object info on terminal");
        this.commandInfos.put(Command.INSPECT, info);
        mainDesc.add(new AttributedString((CharSequence)"inspect [OPTION] OBJECT"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private List<AttributedString> doDescription(String description) {
        ArrayList<AttributedString> out = new ArrayList<AttributedString>();
        out.add(new AttributedString((CharSequence)description));
        return out;
    }

    private int optionIdx(Command cmd, String[] args) {
        for (String a : args) {
            int out = 0;
            if (a.startsWith("-")) {
                return out;
            }
            ++out;
        }
        return -1;
    }

    private List<String> variables() {
        ArrayList<String> out = new ArrayList<String>();
        for (String v : this.engine.find(null).keySet()) {
            out.add("$" + v);
        }
        return out;
    }

    public List<Completer> inspectCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new StringsCompleter(new String[]{"--help", "--methods", "--metaMethods", "--gui", "--info", "-?", "-n", "-m", "-i", "-g"}), new StringsCompleter(this::variables), NullCompleter.INSTANCE});
        out.add((Completer)ac);
        return out;
    }

    public List<Completer> grabCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new StringsCompleter(new String[]{"--help", "-?", "--list", "-l"}), NullCompleter.INSTANCE});
        out.add((Completer)ac);
        return out;
    }

    public List<Completer> defaultCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new StringsCompleter(new String[]{"--help", "-?"}), NullCompleter.INSTANCE});
        out.add((Completer)ac);
        return out;
    }

    public static enum Command {
        INSPECT,
        CONSOLE,
        GRAB;

    }
}

