/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.groovy.ast.tools.ImmutablePropertyUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jline.builtins.Nano;
import org.jline.builtins.Styles;
import org.jline.console.CmdDesc;
import org.jline.console.CmdLine;
import org.jline.console.ScriptEngine;
import org.jline.console.SystemRegistry;
import org.jline.groovy.ObjectInspector;
import org.jline.groovy.Utils;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.JrtJavaBasePackages;
import org.jline.script.PackageHelper;
import org.jline.utils.AttributedString;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class GroovyEngine
implements ScriptEngine {
    public static final String CANONICAL_NAMES = "canonicalNames";
    public static final String NANORC_SYNTAX = "nanorcSyntax";
    public static final String NANORC_VALUE = "nanorcValue";
    public static final String GROOVY_COLORS = "GROOVY_COLORS";
    public static final String NO_SYNTAX_CHECK = "noSyntaxCheck";
    public static final String RESTRICTED_COMPLETION = "restrictedCompletion";
    public static final String ALL_FIELDS_COMPLETION = "allFieldsCompletion";
    public static final String ALL_METHODS_COMPLETION = "allMethodsCompletion";
    public static final String ALL_CONSTRUCTORS_COMPLETION = "allConstructorsCompletion";
    public static final String ALL_CLASSES_COMPLETION = "allClassesCompletion";
    public static final String IDENTIFIERS_COMPLETION = "identifiersCompletion";
    public static final String META_METHODS_COMPLETION = "metaMethodsCompletion";
    private static final String VAR_GROOVY_OPTIONS = "GROOVY_OPTIONS";
    private static final String REGEX_SYSTEM_VAR = "[A-Z]+[A-Z_]*";
    private static final String REGEX_VAR = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private static final Pattern PATTERN_FUNCTION_DEF = Pattern.compile("^def\\s+([a-zA-Z_]+[a-zA-Z0-9_]*)\\s*\\(([a-zA-Z0-9_ ,]*)\\)\\s*\\{(.*)?}(|\n)$", 32);
    private static final Pattern PATTERN_CLASS_DEF = Pattern.compile("^class\\s+([a-zA-Z_]+[a-zA-Z0-9_]*) .*?\\{.*?}(|\n)$", 32);
    private static final Pattern PATTERN_CLASS_NAME = Pattern.compile("(.*?)\\.([A-Z].*)");
    private static final List<String> DEFAULT_IMPORTS = Arrays.asList("java.lang.*", "java.util.*", "java.io.*", "java.net.*", "groovy.lang.*", "groovy.util.*", "java.math.BigInteger", "java.math.BigDecimal");
    private final Map<String, Class<?>> defaultNameClass = new HashMap();
    private final GroovyShell shell;
    protected Binding sharedData;
    private final Map<String, String> imports = new HashMap<String, String>();
    private final Map<String, String> methods = new HashMap<String, String>();
    private final Map<String, Class<?>> nameClass;
    private Cloner objectCloner = new ObjectCloner();

    public GroovyEngine() {
        this.sharedData = new Binding();
        this.shell = new GroovyShell(this.sharedData);
        for (String s : DEFAULT_IMPORTS) {
            this.addToNameClass(s, this.defaultNameClass);
        }
        this.nameClass = new HashMap(this.defaultNameClass);
    }

    public Completer getScriptCompleter() {
        return this.compileCompleter();
    }

    public boolean hasVariable(String name) {
        return this.sharedData.hasVariable(name);
    }

    public void put(String name, Object value) {
        this.sharedData.setProperty(name, value);
    }

    public Object get(String name) {
        return this.sharedData.hasVariable(name) ? this.sharedData.getVariable(name) : null;
    }

    public Map<String, Object> find(String name) {
        HashMap<String, Object> out = new HashMap();
        if (name == null) {
            out = this.sharedData.getVariables();
        } else {
            for (String v : this.internalFind(name)) {
                out.put(v, this.get(v));
            }
        }
        return out;
    }

    public List<String> getSerializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.NONE.toString());
    }

    public List<String> getDeserializationFormats() {
        return Arrays.asList(Format.JSON.toString(), Format.GROOVY.toString(), Format.NONE.toString());
    }

    public Object deserialize(String value, String formatStr) {
        Object out;
        block16: {
            Format format;
            out = value;
            Format format2 = format = formatStr != null && !formatStr.isEmpty() ? Format.valueOf(formatStr.toUpperCase()) : null;
            if (format != Format.NONE) {
                if (format == Format.JSON) {
                    out = Utils.toObject(value);
                } else {
                    if (format == Format.GROOVY) {
                        try {
                            out = this.execute(value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    boolean hasCurly = (value = value.trim()).contains("{") && value.contains("}");
                    try {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            try {
                                if (hasCurly) {
                                    out = Utils.toObject(value);
                                    break block16;
                                }
                                out = this.execute(value);
                            }
                            catch (Exception e) {
                                if (hasCurly) {
                                    try {
                                        out = this.execute(value);
                                    }
                                    catch (Exception exception) {}
                                    break block16;
                                }
                                out = Utils.toObject(value);
                            }
                            break block16;
                        }
                        if (value.startsWith("{") && value.endsWith("}")) {
                            out = Utils.toObject(value);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return out;
    }

    public void persist(Path file, Object object) {
        this.persist(file, object, this.getSerializationFormats().get(0));
    }

    public void persist(Path file, Object object, String format) {
        Utils.persist(file, object, Format.valueOf(format.toUpperCase()));
    }

    public Object execute(File script, Object[] args) throws Exception {
        this.sharedData.setProperty("_args", (Object)args);
        Script s = this.shell.parse(script);
        return s.run();
    }

    private static Set<Class<?>> classesForPackage(String pckgname) throws ClassNotFoundException {
        HashSet out;
        String name = pckgname;
        Matcher matcher = PATTERN_CLASS_NAME.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1) + ".**";
        }
        if ((out = new HashSet(PackageHelper.getClassesForPackage(name))).isEmpty()) {
            out.addAll(JrtJavaBasePackages.getClassesForPackage(name));
        }
        return out;
    }

    private void addToNameClass(String name) {
        this.addToNameClass(name, this.nameClass);
    }

    private void addToNameClass(String name, Map<String, Class<?>> nameClass) {
        try {
            if (name.endsWith(".*")) {
                for (Class<?> c : GroovyEngine.classesForPackage(name)) {
                    nameClass.put(c.getSimpleName(), c);
                }
            } else {
                Class<?> clazz = GroovyEngine.classResolver(name);
                if (clazz != null) {
                    nameClass.put(clazz.getSimpleName(), clazz);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object execute(String statement) throws Exception {
        Object out = null;
        if (statement.startsWith("import ")) {
            this.shell.evaluate(statement);
            String[] p = statement.split("\\s+", 2);
            String classname = p[1].replaceAll(";", "");
            this.imports.put(classname, statement);
            this.addToNameClass(classname);
        } else if (statement.equals("import")) {
            out = new ArrayList<String>(this.imports.keySet());
        } else if (!this.functionDef(statement)) {
            if (statement.equals("def")) {
                out = this.methods;
            } else if (statement.matches("def\\s+[a-zA-Z_]+[a-zA-Z0-9_]*")) {
                String name = statement.split("\\s+")[1];
                if (this.methods.containsKey(name)) {
                    out = "def " + name + this.methods.get(name);
                }
            } else {
                StringBuilder e = new StringBuilder();
                for (Map.Entry<String, String> entry : this.imports.entrySet()) {
                    e.append(entry.getValue()).append("\n");
                }
                e.append(statement);
                if (this.classDef(statement)) {
                    e.append("; null");
                }
                out = this.shell.evaluate(e.toString());
            }
        }
        return out;
    }

    public Object execute(Object closure, Object ... args) {
        if (!(closure instanceof Closure)) {
            throw new IllegalArgumentException();
        }
        return ((Closure)closure).call(args);
    }

    public String getEngineName() {
        return this.getClass().getSimpleName();
    }

    public List<String> getExtensions() {
        return Collections.singletonList("groovy");
    }

    private List<String> internalFind(String var) {
        ArrayList<String> out = new ArrayList<String>();
        if (!var.contains(".") && var.contains("*")) {
            var = var.replaceAll("\\*", ".*");
        }
        for (String v : this.sharedData.getVariables().keySet()) {
            if (!v.matches(var)) continue;
            out.add(v);
        }
        return out;
    }

    private boolean functionDef(String statement) throws Exception {
        boolean out = false;
        Matcher m = PATTERN_FUNCTION_DEF.matcher(statement);
        if (m.matches()) {
            out = true;
            this.put(m.group(1), this.execute("{" + m.group(2) + "->" + m.group(3) + "}"));
            this.methods.put(m.group(1), "(" + m.group(2) + "){" + m.group(3) + "}");
        }
        return out;
    }

    private boolean classDef(String statement) {
        return PATTERN_CLASS_DEF.matcher(statement).matches();
    }

    private void refreshNameClass() {
        this.nameClass.clear();
        this.nameClass.putAll(this.defaultNameClass);
        for (String name : this.imports.keySet()) {
            this.addToNameClass(name);
        }
    }

    private void del(String var) {
        if (var == null) {
            return;
        }
        if (this.imports.containsKey(var)) {
            this.imports.remove(var);
            if (var.endsWith(".*")) {
                this.refreshNameClass();
            } else {
                this.nameClass.remove(var.substring(var.lastIndexOf(46) + 1));
            }
        } else if (this.sharedData.hasVariable(var)) {
            this.sharedData.getVariables().remove(var);
            this.methods.remove(var);
        } else if (!var.contains(".") && var.contains("*")) {
            for (String v : this.internalFind(var)) {
                if (!this.sharedData.hasVariable(v) || v.equals("_") || v.matches(REGEX_SYSTEM_VAR)) continue;
                this.sharedData.getVariables().remove(v);
                this.methods.remove(v);
            }
        }
    }

    public void del(String ... vars) {
        if (vars == null) {
            return;
        }
        for (String s : vars) {
            this.del(s);
        }
    }

    public String toJson(Object obj) {
        return Utils.toJson(obj);
    }

    public String toString(Object obj) {
        return Utils.toString(obj);
    }

    public Map<String, Object> toMap(Object obj) {
        return Utils.toMap(obj);
    }

    public void setObjectCloner(Cloner objectCloner) {
        this.objectCloner = objectCloner;
    }

    public Cloner getObjectCloner() {
        return this.objectCloner;
    }

    public CmdDesc scriptDescription(CmdLine line) {
        return new Inspector(this).scriptDescription(line);
    }

    protected Map<String, Object> groovyOptions() {
        return this.hasVariable(VAR_GROOVY_OPTIONS) ? (Map)this.get(VAR_GROOVY_OPTIONS) : new HashMap();
    }

    protected <T> T groovyOption(String option, T defval) {
        return GroovyEngine.groovyOption(this.groovyOptions(), option, defval);
    }

    protected static <T> T groovyOption(Map<String, Object> options, String option, T defval) {
        Object out = defval;
        try {
            out = options.getOrDefault(option, defval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private Completer compileCompleter() {
        ArrayList<Object> completers = new ArrayList<Object>();
        completers.add(new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"class", "print", "println"}), NullCompleter.INSTANCE}));
        Completer[] completerArray = new Completer[3];
        completerArray[0] = new StringsCompleter(new String[]{"def"});
        completerArray[1] = new StringsCompleter(this.methods::keySet);
        completerArray[2] = NullCompleter.INSTANCE;
        completers.add(new ArgumentCompleter(completerArray));
        completers.add(new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"import"}), new PackageCompleter(CandidateType.PACKAGE, this), NullCompleter.INSTANCE}));
        completers.add(new MethodCompleter(this));
        return new AggregateCompleter(completers);
    }

    private static Class<?> classResolver(String classDotName) {
        Class<?> out;
        block3: {
            out = null;
            Matcher matcher = PATTERN_CLASS_NAME.matcher(classDotName);
            if (matcher.matches()) {
                String classname = matcher.group(2).replaceAll("\\.", "\\$");
                try {
                    out = Class.forName(matcher.group(1) + "." + classname);
                }
                catch (ClassNotFoundException ex) {
                    if (!Log.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                }
            }
        }
        return out;
    }

    private static class Brackets {
        static final List<Character> DELIMS = Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('='), Character.valueOf('/'));
        static char[] quote = new char[]{'\"', '\''};
        Deque<Integer> roundOpen = new ArrayDeque<Integer>();
        Deque<Integer> curlyOpen = new ArrayDeque<Integer>();
        Map<Integer, Integer> lastComma = new HashMap<Integer, Integer>();
        int lastRoundClose = -1;
        int lastCurlyClose = -1;
        int lastSemicolon = -1;
        int lastBlanck = -1;
        int lastDelim = -1;
        int quoteId = -1;
        int round = 0;
        int curly = 0;
        int square = 0;
        int rounds = 0;
        int curlies = 0;

        public Brackets(String line) {
            int pos = -1;
            char prevChar = ' ';
            for (char ch : line.toCharArray()) {
                ++pos;
                if (this.quoteId < 0) {
                    for (int i = 0; i < quote.length; ++i) {
                        if (ch != quote[i]) continue;
                        this.quoteId = i;
                        break;
                    }
                } else {
                    if (ch != quote[this.quoteId]) continue;
                    this.quoteId = -1;
                    continue;
                }
                if (this.quoteId >= 0) continue;
                if (ch == '(') {
                    ++this.round;
                    this.roundOpen.add(pos);
                } else if (ch == ')') {
                    ++this.rounds;
                    --this.round;
                    this.lastComma.remove(this.roundOpen.getLast());
                    this.roundOpen.removeLast();
                    this.lastRoundClose = pos;
                } else if (ch == '{') {
                    ++this.curly;
                    this.curlyOpen.add(pos);
                } else if (ch == '}') {
                    ++this.curlies;
                    --this.curly;
                    this.curlyOpen.removeLast();
                    this.lastCurlyClose = pos;
                } else if (ch == '[') {
                    ++this.square;
                } else if (ch == ']') {
                    --this.square;
                } else if (ch == ',' && !this.roundOpen.isEmpty()) {
                    this.lastComma.put(this.roundOpen.getLast(), pos);
                } else if (ch == ';' || ch == '\n' || ch == '>' && prevChar == '-') {
                    this.lastSemicolon = pos;
                } else if (ch == ' ' && this.round == 0 && String.valueOf(prevChar).matches("\\w")) {
                    this.lastBlanck = pos;
                } else if (DELIMS.contains(Character.valueOf(ch))) {
                    this.lastDelim = pos;
                }
                prevChar = ch;
                if (this.round >= 0 && this.curly >= 0 && this.square >= 0) continue;
                throw new IllegalArgumentException();
            }
        }

        public static int indexOfOpeningRound(String line) {
            int out = -1;
            if (!line.endsWith(")")) {
                return out;
            }
            int quoteId = -1;
            int round = 0;
            int curly = 0;
            char[] chars = line.toCharArray();
            for (int i = line.length() - 1; i >= 0; --i) {
                char ch = chars[i];
                if (quoteId < 0) {
                    for (int j = 0; j < quote.length; ++j) {
                        if (ch != quote[j]) continue;
                        quoteId = j;
                        break;
                    }
                } else {
                    if (ch != quote[quoteId]) continue;
                    quoteId = -1;
                    continue;
                }
                if (quoteId >= 0) continue;
                if (ch == '(') {
                    ++round;
                } else if (ch == ')') {
                    --round;
                } else if (ch == '{') {
                    ++curly;
                } else if (ch == '}') {
                    --curly;
                }
                if (curly != 0 || round != 0) continue;
                out = i;
                break;
            }
            return out;
        }

        public boolean openRound() {
            return this.round > 0;
        }

        public boolean openCurly() {
            return this.curly > 0;
        }

        public boolean openSquare() {
            return this.square > 0;
        }

        public int numberOfRounds() {
            return this.rounds;
        }

        public int lastOpenRound() {
            return !this.roundOpen.isEmpty() ? this.roundOpen.getLast() : -1;
        }

        public int lastCloseRound() {
            return this.lastRoundClose;
        }

        public int lastOpenCurly() {
            return !this.curlyOpen.isEmpty() ? this.curlyOpen.getLast() : -1;
        }

        public int lastCloseCurly() {
            return this.lastCurlyClose;
        }

        public int lastComma() {
            int last = this.lastOpenRound();
            return this.lastComma.getOrDefault(last, -1);
        }

        public int lastSemicolon() {
            return this.lastSemicolon;
        }

        public int lastDelim() {
            return this.lastDelim;
        }

        public boolean openQuote() {
            return this.quoteId != -1;
        }

        public String toString() {
            return "rounds: " + this.rounds + "\ncurlies: " + this.curlies + "\nlastOpenRound: " + this.lastOpenRound() + "\nlastCloseRound: " + this.lastRoundClose + "\nlastComma: " + this.lastComma() + "\n";
        }
    }

    private static class ObjectCloner
    implements Cloner {
        Map<String, Object> cache = new HashMap<String, Object>();
        Set<String> marked = new HashSet<String>();

        @Override
        public Object clone(Object obj) {
            Object out;
            if (obj == null || ImmutablePropertyUtils.builtinOrMarkedImmutableClass(obj.getClass()) || obj instanceof Exception || obj instanceof Closure) {
                return obj;
            }
            String key = this.cacheKey(obj);
            try {
                if (this.cache.containsKey(key)) {
                    this.marked.remove(key);
                    out = this.cache.get(key);
                } else {
                    Class<?> clazz = obj.getClass();
                    Method clone = clazz.getDeclaredMethod("clone", new Class[0]);
                    out = clone.invoke(obj, new Object[0]);
                    this.cache.put(key, out);
                }
            }
            catch (Exception e) {
                out = obj;
                this.cache.put(key, out);
            }
            return out;
        }

        @Override
        public void markCache() {
            this.marked = new HashSet<String>(this.cache.keySet());
        }

        @Override
        public void purgeCache() {
            for (String k : this.marked) {
                this.cache.remove(k);
            }
        }

        private String cacheKey(Object obj) {
            return obj.getClass().getCanonicalName() + ":" + obj.hashCode();
        }
    }

    private static class Inspector {
        static final Pattern PATTERN_FOR = Pattern.compile("^for\\s*\\((.*?)");
        static final Pattern PATTERN_FOR_EACH = Pattern.compile("^for\\s*\\((.*?):(.*?)\\).*");
        static final Pattern PATTERN_LAMBDA = Pattern.compile(".*\\([(]*(.*?)[)]*->.*");
        static final Pattern PATTERN_FUNCTION_BODY = Pattern.compile("^\\s*\\(([a-zA-Z0-9_ ,]*)\\)\\s*\\{(.*)?}(|\n)$", 32);
        static final Pattern PATTERN_FUNCTION = Pattern.compile("\\s*def\\s+\\w+\\s*\\((.*?)\\).*");
        static final Pattern PATTERN_CLOSURE = Pattern.compile(".*\\{(.*?)->.*");
        static final Pattern PATTERN_TYPE_VAR = Pattern.compile("(\\w+)\\s+(\\w+)");
        static final String DEFAULT_NANORC_SYNTAX = "classpath:/org/jline/groovy/java.nanorc";
        static final String DEFAULT_GROOVY_COLORS = "ti=1;34:me=31";
        private final GroovyShell shell;
        protected Binding sharedData = new Binding();
        private final Map<String, String> imports;
        private final Map<String, Class<?>> nameClass;
        private PrintStream nullstream;
        private boolean canonicalNames = false;
        private final boolean noSyntaxCheck;
        private final boolean restrictedCompletion;
        private final boolean metaMethodsCompletion;
        private final AccessRules access;
        private String[] equationLines;
        private int cuttedSize;
        private final String nanorcSyntax;
        private final String groovyColors;
        private Object involvedObject = null;

        public Inspector(GroovyEngine groovyEngine) {
            this.imports = groovyEngine.imports;
            this.nameClass = groovyEngine.nameClass;
            this.canonicalNames = groovyEngine.groovyOption(GroovyEngine.CANONICAL_NAMES, this.canonicalNames);
            this.nanorcSyntax = groovyEngine.groovyOption(GroovyEngine.NANORC_SYNTAX, DEFAULT_NANORC_SYNTAX);
            this.noSyntaxCheck = groovyEngine.groovyOption(GroovyEngine.NO_SYNTAX_CHECK, false);
            this.restrictedCompletion = groovyEngine.groovyOption(GroovyEngine.RESTRICTED_COMPLETION, false);
            this.metaMethodsCompletion = groovyEngine.groovyOption(GroovyEngine.META_METHODS_COMPLETION, false);
            this.access = new AccessRules(groovyEngine.groovyOptions());
            String gc = groovyEngine.groovyOption(GroovyEngine.GROOVY_COLORS, null);
            this.groovyColors = gc != null && Styles.isAnsiStylePattern((String)gc) ? gc : DEFAULT_GROOVY_COLORS;
            groovyEngine.getObjectCloner().markCache();
            for (Map.Entry entry : groovyEngine.find().entrySet()) {
                Object obj = groovyEngine.getObjectCloner().clone(entry.getValue());
                this.sharedData.setVariable((String)entry.getKey(), obj);
            }
            groovyEngine.getObjectCloner().purgeCache();
            this.shell = new GroovyShell(this.sharedData);
            try {
                File file = OSUtils.IS_WINDOWS ? new File("NUL") : new File("/dev/null");
                FileOutputStream outputStream = new FileOutputStream(file);
                this.nullstream = new PrintStream(outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Map.Entry entry : groovyEngine.methods.entrySet()) {
                Matcher m = PATTERN_FUNCTION_BODY.matcher((CharSequence)entry.getValue());
                if (!m.matches() || !this.sharedData.hasVariable((String)entry.getKey()) || !(this.sharedData.getVariable((String)entry.getKey()) instanceof Closure)) continue;
                this.sharedData.setVariable((String)entry.getKey(), this.execute("{" + m.group(1) + "->" + m.group(2) + "}"));
            }
        }

        public Object getInvolvedObject() {
            return this.involvedObject;
        }

        public Class<?> evaluateClass(String objectStatement) {
            Class<Object> out = null;
            try {
                this.involvedObject = this.execute(objectStatement);
                out = this.involvedObject.getClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (out == null || out == Class.class) {
                    out = !objectStatement.contains(".") ? (Class<Object>)this.execute(objectStatement + ".class") : Class.forName(objectStatement);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object execute(String statement) {
            Object out;
            PrintStream origOut = System.out;
            PrintStream origErr = System.err;
            if (this.nullstream != null) {
                System.setOut(this.nullstream);
                System.setErr(this.nullstream);
            }
            try {
                StringBuilder e = new StringBuilder();
                for (Map.Entry<String, String> entry : this.imports.entrySet()) {
                    e.append(entry.getValue()).append("\n");
                }
                e.append(statement);
                out = this.shell.evaluate(e.toString());
            }
            finally {
                System.setOut(origOut);
                System.setErr(origErr);
            }
            return out;
        }

        private String stripVarType(String statement) {
            if (statement.matches("\\w+\\s+\\w+.*")) {
                int idx = statement.indexOf(32);
                return statement.substring(idx + 1);
            }
            return statement;
        }

        private String defineArgs(String[] args) {
            StringBuilder out = new StringBuilder();
            for (String v : args) {
                Matcher matcher = PATTERN_TYPE_VAR.matcher(v.trim());
                if (matcher.matches()) {
                    out.append(this.constructVariable(matcher.group(1), matcher.group(2)));
                    continue;
                }
                out.append(v).append(" = null; ");
            }
            return out.toString();
        }

        private String constructVariable(String type, String name) {
            String out = "";
            if (type.matches("[B|b]yte") || type.matches("[S|s]hort") || type.equals("int") || type.equals("Integer") || type.matches("[L|l]ong") || type.matches("[F|f]loat") || type.matches("[D|d]ouble") || type.matches("[B|b]oolean") || type.equals("char") || type.equals("Character")) {
                out = name + " = (" + type + ")0; ";
            } else if (type.matches("[A-Z].*")) {
                out = "try {" + name + " = new " + type + "() } catch (Exception e) {" + name + " = null}; ";
            }
            return out;
        }

        public void loadStatementVars(String line) {
            if (!new Brackets(line).openCurly()) {
                return;
            }
            for (String s : line.split("\\r?\\n|;")) {
                String statement = s.trim();
                boolean constructedStatement = true;
                try {
                    Matcher forEachMatcher = PATTERN_FOR_EACH.matcher(statement);
                    Matcher forMatcher = PATTERN_FOR.matcher(statement);
                    Matcher lambdaMatcher = PATTERN_LAMBDA.matcher(statement);
                    Matcher functionMatcher = PATTERN_FUNCTION.matcher(statement);
                    Matcher closureMatcher = PATTERN_CLOSURE.matcher(statement);
                    Matcher typeVarMatcher = PATTERN_TYPE_VAR.matcher(statement);
                    if (statement.matches("^(if|while)\\s*\\(.*") || statement.matches("(}\\s*|^)else(\\s*\\{|$)") || statement.matches("(}\\s*|^)else\\s+if\\s*\\(.*") || statement.matches("^break[;]+") || statement.matches("^case\\s+.*:") || statement.matches("^default\\s+:") || statement.matches("([{}])") || statement.length() == 0) continue;
                    if (forEachMatcher.matches()) {
                        statement = this.stripVarType(forEachMatcher.group(1).trim());
                        String cc = forEachMatcher.group(2);
                        statement = statement + "=" + cc + " instanceof Map ? " + cc + ".entrySet()[0] : " + cc + "[0]";
                    } else if (forMatcher.matches()) {
                        statement = this.stripVarType(forMatcher.group(1).trim());
                        if (!statement.contains("=")) {
                            statement = statement + " = null";
                        }
                    } else if (closureMatcher.matches()) {
                        statement = this.defineArgs(closureMatcher.group(1).split(","));
                    } else if (functionMatcher.matches()) {
                        statement = this.defineArgs(functionMatcher.group(1).split(","));
                    } else if (lambdaMatcher.matches()) {
                        statement = this.defineArgs(lambdaMatcher.group(1).split(","));
                    } else if (statement.contains("=")) {
                        statement = this.stripVarType(statement);
                        constructedStatement = false;
                    } else if (typeVarMatcher.matches()) {
                        statement = this.constructVariable(typeVarMatcher.group(1), typeVarMatcher.group(2));
                    }
                    Brackets br = new Brackets(statement);
                    if (!statement.contains("=") || br.openRound() || br.openCurly() || br.openSquare()) continue;
                    int idx = statement.indexOf(61);
                    String st = "null";
                    if (this.restrictedCompletion && !constructedStatement && br.numberOfRounds() > 0) {
                        statement = statement.substring(0, idx + 1) + "null";
                    } else {
                        st = statement.substring(idx + 1).trim();
                    }
                    if (st.isEmpty() || st.equals("new")) continue;
                    this.execute(statement);
                }
                catch (Exception e) {
                    if (!Log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
            }
        }

        public Map<String, Class<?>> nameClass() {
            return this.nameClass;
        }

        public Set<String> variables() {
            return this.sharedData.getVariables().keySet();
        }

        public boolean hasVariable(String name) {
            return this.sharedData.hasVariable(name);
        }

        public Object getVariable(String name) {
            return this.sharedData.hasVariable(name) ? this.sharedData.getVariable(name) : null;
        }

        public CmdDesc scriptDescription(CmdLine line) {
            CmdDesc out;
            block7: {
                out = null;
                try {
                    switch (line.getDescriptionType()) {
                        case COMMAND: {
                            break;
                        }
                        case METHOD: {
                            out = this.methodDescription(line);
                            break;
                        }
                        case SYNTAX: {
                            if (this.noSyntaxCheck) break;
                            out = this.checkSyntax(line);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!Log.isDebugEnabled()) break block7;
                    e.printStackTrace();
                }
            }
            return out;
        }

        private String trimName(String name) {
            String out = name;
            int idx = name.lastIndexOf(40);
            if (idx > 0) {
                out = name.substring(0, idx);
            }
            return out;
        }

        private String accessModifier(int modifier, boolean all) {
            String out = "";
            if (!all) {
                return out;
            }
            if (Modifier.isPrivate(modifier)) {
                out = "private ";
            } else if (Modifier.isProtected(modifier)) {
                out = "protected ";
            } else if (Modifier.isPublic(modifier)) {
                out = "public ";
            }
            return out;
        }

        /*
         * WARNING - void declaration
         */
        private CmdDesc methodDescription(CmdLine line) {
            CmdDesc out = new CmdDesc();
            List args = line.getArgs();
            boolean constructor = false;
            Class<Object> clazz = null;
            String methodName = null;
            String buffer = line.getHead();
            int eqsep = Helpers.statementBegin(buffer);
            int varsep = buffer.lastIndexOf(46);
            if (varsep > 0 && varsep > eqsep) {
                String st;
                this.loadStatementVars(buffer);
                methodName = buffer.substring(varsep + 1);
                int ior = Brackets.indexOfOpeningRound(buffer.substring(0, varsep));
                if (ior > 0 && ior < eqsep) {
                    eqsep = ior;
                }
                if ((st = buffer.substring(eqsep + 1, varsep)).matches("[A-Z]+\\w+\\s*\\(.*")) {
                    st = "new " + st;
                }
                int nb = new Brackets(st).numberOfRounds();
                if (!this.restrictedCompletion || nb == 0) {
                    clazz = this.evaluateClass(st);
                }
            } else if (args.size() > 1 && Helpers.constructorStatement((String)args.get(args.size() - 2)) && ((String)args.get(args.size() - 1)).matches("[A-Z]+\\w+\\s*\\(.*") && new Brackets((String)args.get(args.size() - 1)).openRound()) {
                constructor = true;
                clazz = this.evaluateClass(this.trimName((String)args.get(args.size() - 1)));
            }
            ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
            if (clazz != null) {
                Nano.SyntaxHighlighter java = Nano.SyntaxHighlighter.build((String)this.nanorcSyntax);
                mainDesc.add(java.highlight(clazz.toString()));
                if (constructor) {
                    void var14_19;
                    Constructor<?>[] nb = this.access.allConstructors ? clazz.getDeclaredConstructors() : clazz.getConstructors();
                    int n = nb.length;
                    boolean bl = false;
                    while (var14_19 < n) {
                        Constructor<?> m = nb[var14_19];
                        StringBuilder sb = new StringBuilder();
                        String name = m.getName();
                        if (!this.canonicalNames) {
                            int idx = name.lastIndexOf(46);
                            name = name.substring(idx + 1);
                        }
                        sb.append(this.accessModifier(m.getModifiers(), this.access.allConstructors));
                        sb.append(name);
                        sb.append("(");
                        boolean first = true;
                        for (Class<?> p : m.getParameterTypes()) {
                            if (!first) {
                                sb.append(", ");
                            }
                            sb.append(this.canonicalNames ? p.getTypeName() : p.getSimpleName());
                            first = false;
                        }
                        sb.append(")");
                        first = true;
                        for (Class<?> e : m.getExceptionTypes()) {
                            if (first) {
                                sb.append(" throws ");
                            } else {
                                sb.append(", ");
                            }
                            sb.append(this.canonicalNames ? e.getCanonicalName() : e.getSimpleName());
                            first = false;
                        }
                        mainDesc.add(java.highlight(this.trimMethodDescription(sb)));
                        ++var14_19;
                    }
                } else {
                    StringBuilder sb;
                    ArrayList<String> addedMethods = new ArrayList<String>();
                    if (this.metaMethodsCompletion && this.involvedObject != null) {
                        for (Map map : new ObjectInspector(this.involvedObject).metaMethods(false)) {
                            if (!((String)map.get("name")).equals(methodName)) continue;
                            sb = new StringBuilder();
                            String modifiers = (String)map.get("modifiers");
                            if (!this.access.allMethods) {
                                if (modifiers.equals("public")) {
                                    modifiers = "";
                                } else if (modifiers.startsWith("public ")) {
                                    modifiers = modifiers.substring(7);
                                }
                            }
                            if (!modifiers.isEmpty()) {
                                sb.append(modifiers).append(" ");
                            }
                            sb.append(this.convertArrayParams((String)map.get("return"))).append(" ");
                            sb.append(methodName).append("(");
                            sb.append(this.convertArrayParams((String)map.get("parameters")));
                            sb.append(")");
                            if (addedMethods.contains(sb.toString())) continue;
                            addedMethods.add(sb.toString());
                            mainDesc.add(java.highlight(this.trimMethodDescription(sb)));
                        }
                    }
                    do {
                        for (Method method : Helpers.getClassMethods(clazz, this.access.allMethods)) {
                            if (!method.getName().equals(methodName)) continue;
                            sb = new StringBuilder();
                            sb.append(this.accessModifier(method.getModifiers(), this.access.allMethods));
                            if (Modifier.isFinal(method.getModifiers())) {
                                sb.append("final ");
                            }
                            if (Modifier.isStatic(method.getModifiers())) {
                                sb.append("static ");
                            }
                            sb.append(this.canonicalNames ? method.getReturnType().getCanonicalName() : method.getReturnType().getSimpleName());
                            sb.append(" ");
                            sb.append(methodName);
                            sb.append("(");
                            boolean first = true;
                            for (Class<?> p : method.getParameterTypes()) {
                                if (!first) {
                                    sb.append(", ");
                                }
                                sb.append(this.canonicalNames ? p.getTypeName() : p.getSimpleName());
                                first = false;
                            }
                            sb.append(")");
                            first = true;
                            for (Class<?> e : method.getExceptionTypes()) {
                                if (first) {
                                    sb.append(" throws ");
                                } else {
                                    sb.append(", ");
                                }
                                sb.append(this.canonicalNames ? e.getCanonicalName() : e.getSimpleName());
                                first = false;
                            }
                            if (addedMethods.contains(sb.toString())) continue;
                            addedMethods.add(sb.toString());
                            mainDesc.add(java.highlight(this.trimMethodDescription(sb)));
                        }
                    } while ((clazz = clazz.getSuperclass()) != null);
                }
                out.setMainDesc(mainDesc);
            }
            return out;
        }

        private String convertArrayParams(String value) {
            String out = value.replaceAll("\\[B", "byte[]");
            Pattern arrayPattern = Pattern.compile("(.*)\\[L.*\\.([A-Z].*?);(.*)");
            Matcher matcher = arrayPattern.matcher(value);
            while (matcher.matches()) {
                out = matcher.group(1) + matcher.group(2) + "[]" + matcher.group(3);
                matcher = arrayPattern.matcher(out);
            }
            return out;
        }

        private String trimMethodDescription(StringBuilder sb) {
            String out = sb.toString();
            if (this.canonicalNames) {
                out = out.replaceAll("java\\.lang\\.", "");
            }
            return out;
        }

        private CmdDesc checkSyntax(CmdLine line) {
            CmdDesc out = new CmdDesc();
            int openingRound = Brackets.indexOfOpeningRound(line.getHead());
            if (openingRound == -1) {
                return out;
            }
            String cuttedLine = line.getHead().substring(0, openingRound);
            if (new Brackets(cuttedLine).openQuote()) {
                return out;
            }
            this.loadStatementVars(line.getHead());
            int eqsep = Helpers.statementBegin(cuttedLine);
            int end = line.getHead().length();
            if (eqsep > 0 && Helpers.constructorStatement(line.getHead().substring(0, eqsep))) {
                eqsep = line.getHead().substring(0, eqsep).lastIndexOf("new") - 1;
            } else if (line.getHead().substring(eqsep + 1).matches("\\s*for\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*while\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*else\\s+if\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*if\\s*\\(.*")) {
                eqsep = openingRound;
                --end;
            } else if (line.getHead().substring(eqsep + 1).matches("\\s*switch\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*def\\s+\\w+\\s*\\(.*") || line.getHead().substring(eqsep + 1).matches("\\s*catch\\s*\\(.*")) {
                return out;
            }
            ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
            String objEquation = line.getHead().substring(eqsep + 1, end).trim();
            this.equationLines = objEquation.split("\\r?\\n");
            this.cuttedSize = eqsep + 1;
            if (!objEquation.matches("\\(\\s*\\w+\\s*[,\\s*\\w+]*\\)") && !objEquation.matches("\\(\\s*\\)")) {
                try {
                    this.execute(objEquation);
                }
                catch (MissingPropertyException e) {
                    mainDesc.addAll(this.doExceptionMessage((Exception)((Object)e)));
                    out.setErrorPattern(Pattern.compile("\\b" + e.getProperty() + "\\b"));
                }
                catch (PatternSyntaxException e) {
                    mainDesc.addAll(this.doExceptionMessage(e));
                    int idx = line.getHead().lastIndexOf(e.getPattern());
                    if (idx >= 0) {
                        out.setErrorIndex(idx + e.getIndex());
                    }
                }
                catch (MultipleCompilationErrorsException e) {
                    SyntaxErrorMessage sem;
                    if (e.getErrorCollector().getErrors() != null) {
                        for (Object o : e.getErrorCollector().getErrors()) {
                            if (!(o instanceof SyntaxErrorMessage)) continue;
                            sem = (SyntaxErrorMessage)o;
                            out.setErrorIndex(this.errorIndex(e.getMessage(), sem.getCause()));
                        }
                    }
                    if (e.getErrorCollector().getWarnings() != null) {
                        for (Object o : e.getErrorCollector().getWarnings()) {
                            if (!(o instanceof SyntaxErrorMessage)) continue;
                            sem = (SyntaxErrorMessage)o;
                            out.setErrorIndex(this.errorIndex(e.getMessage(), sem.getCause()));
                        }
                    }
                    mainDesc.addAll(this.doExceptionMessage((Exception)((Object)e)));
                }
                catch (MissingMethodException e) {
                    if (!e.getMessage().split("\r?\n")[0].matches(".*types:\\s+\\(.*null.*\\).*")) {
                        mainDesc.addAll(this.doExceptionMessage((Exception)((Object)e)));
                    }
                }
                catch (NullPointerException e) {
                }
                catch (Exception e) {
                    mainDesc.addAll(this.doExceptionMessage(e));
                }
            }
            out.setMainDesc(mainDesc);
            return out;
        }

        private List<AttributedString> doExceptionMessage(Exception exception) {
            ArrayList<AttributedString> out = new ArrayList<AttributedString>();
            Nano.SyntaxHighlighter java = Nano.SyntaxHighlighter.build((String)this.nanorcSyntax);
            StyleResolver resolver = Inspector.style(this.groovyColors);
            Pattern header = Pattern.compile("^[a-zA-Z() ]{3,}:(\\s+|$)");
            out.add(java.highlight(exception.getClass().getCanonicalName()));
            if (exception.getMessage() != null) {
                for (String s : exception.getMessage().split("\\r?\\n")) {
                    if (s.trim().length() == 0) continue;
                    if (s.length() > 80) {
                        boolean doHeader = true;
                        int start = 0;
                        for (int i = 80; i < s.length(); ++i) {
                            if ((s.charAt(i) != ' ' || i - start <= 80) && i - start <= 100) continue;
                            AttributedString as = new AttributedString((CharSequence)s.substring(start, i), resolver.resolve(".me"));
                            if (doHeader) {
                                as = as.styleMatches(header, resolver.resolve(".ti"));
                                doHeader = false;
                            }
                            out.add(as);
                            start = i;
                            if (s.length() - start >= 80) continue;
                            out.add(new AttributedString((CharSequence)s.substring(start), resolver.resolve(".me")));
                            break;
                        }
                        if (!doHeader) continue;
                        AttributedString as = new AttributedString((CharSequence)s, resolver.resolve(".me"));
                        as = as.styleMatches(header, resolver.resolve(".ti"));
                        out.add(as);
                        continue;
                    }
                    AttributedString as = new AttributedString((CharSequence)s, resolver.resolve(".me"));
                    as = as.styleMatches(header, resolver.resolve(".ti"));
                    out.add(as);
                }
            }
            return out;
        }

        private int errorIndex(String message, SyntaxException se) {
            String line = null;
            String[] mlines = message.split("\n");
            for (int i = 0; i < mlines.length; ++i) {
                if (!mlines[i].matches(".*Script[0-9]+\\.groovy: .*")) continue;
                line = mlines[i + 1].trim();
                break;
            }
            int tot = 0;
            if (line != null) {
                for (String l : this.equationLines) {
                    if (l.contains(line)) break;
                    tot += l.length() + 1;
                }
            }
            int out = this.cuttedSize + tot + se.getStartColumn() - 1;
            return out;
        }

        private static StyleResolver style(String style) {
            Map<String, String> colors = Arrays.stream(style.split(":")).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
            return new StyleResolver(colors::get);
        }
    }

    private static class MethodCompleter
    implements Completer {
        private static final List<String> VALUES = Arrays.asList("true", "false");
        private final GroovyEngine groovyEngine;
        private final SystemRegistry systemRegistry = SystemRegistry.get();
        private Inspector inspector;
        private AccessRules access;
        private boolean metaMethodCompletion;
        private boolean identifierCompletion;

        public MethodCompleter(GroovyEngine engine) {
            this.groovyEngine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            Brackets brackets;
            assert (commandLine != null);
            assert (candidates != null);
            if (this.systemRegistry.isCommandOrScript(commandLine) || commandLine.wordIndex() > 0 && ((String)commandLine.words().get(0)).equals("import")) {
                return;
            }
            String wordbuffer = commandLine.word();
            String buffer = commandLine.line().substring(0, commandLine.cursor());
            try {
                brackets = new Brackets(buffer);
            }
            catch (Exception e) {
                return;
            }
            if (brackets.openQuote()) {
                return;
            }
            boolean restrictedCompletion = this.groovyEngine.groovyOption(GroovyEngine.RESTRICTED_COMPLETION, false);
            this.metaMethodCompletion = this.groovyEngine.groovyOption(GroovyEngine.META_METHODS_COMPLETION, false);
            this.identifierCompletion = this.groovyEngine.groovyOption(GroovyEngine.IDENTIFIERS_COMPLETION, false);
            this.access = new AccessRules(this.groovyEngine.groovyOptions());
            this.inspector = new Inspector(this.groovyEngine);
            this.inspector.loadStatementVars(buffer);
            int eqsep = Helpers.statementBegin(buffer);
            if (brackets.numberOfRounds() > 0 && brackets.lastCloseRound() > eqsep) {
                int varsep = buffer.lastIndexOf(46);
                if (varsep > 0 && varsep > brackets.lastCloseRound() && !restrictedCompletion) {
                    Class<?> clazz = this.inspector.evaluateClass(buffer.substring(eqsep + 1, varsep));
                    Object involvedObject = this.inspector.getInvolvedObject();
                    int vs = wordbuffer.lastIndexOf(46);
                    String curBuf = wordbuffer.substring(0, vs + 1);
                    this.doMethodCandidates(candidates, involvedObject == null ? clazz : involvedObject, curBuf);
                }
            } else if (this.completingConstructor(commandLine)) {
                if (wordbuffer.matches("[a-z]+.*")) {
                    int idx = wordbuffer.lastIndexOf(46);
                    if (idx > 0 && wordbuffer.substring(idx + 1).matches("[A-Z]+.*")) {
                        try {
                            Class.forName(wordbuffer);
                            Helpers.doCandidates(candidates, Collections.singletonList("("), wordbuffer, CandidateType.OTHER);
                        }
                        catch (Exception e) {
                            String param = wordbuffer.substring(0, idx + 1);
                            Helpers.doCandidates(candidates, Helpers.nextDomain(param, CandidateType.CONSTRUCTOR), param, CandidateType.CONSTRUCTOR);
                        }
                    } else {
                        new PackageCompleter(CandidateType.CONSTRUCTOR, this.groovyEngine).complete(reader, commandLine, candidates);
                    }
                } else {
                    Helpers.doCandidates(candidates, this.retrieveConstructors(this.access.allConstructors), "", CandidateType.CONSTRUCTOR);
                }
            } else {
                boolean addKeyWords = eqsep == brackets.lastSemicolon() || eqsep == brackets.lastOpenCurly();
                int varsep = wordbuffer.lastIndexOf(46);
                eqsep = Helpers.statementBegin(buffer, wordbuffer, brackets);
                String param = wordbuffer.substring(eqsep + 1);
                if (param.trim().length() != 0) {
                    if (varsep < 0 || varsep < eqsep) {
                        String curBuf = wordbuffer.substring(0, eqsep + 1);
                        if (addKeyWords) {
                            Helpers.doCandidates(candidates, ObjectInspector.GLOBAL_META_METHODS, curBuf, CandidateType.METHOD);
                        } else {
                            Helpers.doCandidates(candidates, VALUES, curBuf, CandidateType.OTHER);
                        }
                        Helpers.doCandidates(candidates, this.inspector.variables(), curBuf, CandidateType.OTHER);
                        Helpers.doCandidates(candidates, this.retrieveClassesWithStaticMethods(), curBuf, CandidateType.PACKAGE);
                    } else {
                        boolean firstMethod = param.indexOf(46) == param.lastIndexOf(46);
                        String var = param.substring(0, param.indexOf(46));
                        String curBuf = wordbuffer.substring(0, varsep + 1);
                        if (this.inspector.nameClass().containsKey(var)) {
                            if (firstMethod) {
                                this.doStaticMethodCandidates(candidates, this.inspector.nameClass().get(var), curBuf);
                            } else if (!restrictedCompletion) {
                                Class<?> clazz = this.inspector.evaluateClass(wordbuffer.substring(eqsep + 1, varsep));
                                Object involvedObject = this.inspector.getInvolvedObject();
                                this.doMethodCandidates(candidates, involvedObject == null ? clazz : involvedObject, curBuf);
                            }
                        } else if (this.inspector.hasVariable(var)) {
                            if (firstMethod) {
                                this.doMethodCandidates(candidates, this.inspector.getVariable(var), curBuf);
                            } else if (!restrictedCompletion) {
                                Class<?> clazz = this.inspector.evaluateClass(wordbuffer.substring(eqsep + 1, varsep));
                                Object involvedObject = this.inspector.getInvolvedObject();
                                this.doMethodCandidates(candidates, involvedObject == null ? clazz : involvedObject, curBuf);
                            }
                        } else {
                            try {
                                param = wordbuffer.substring(eqsep + 1, varsep);
                                Class clazz = GroovyEngine.classResolver(param);
                                if (clazz != null) {
                                    this.doStaticMethodCandidates(candidates, clazz, curBuf);
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                param = wordbuffer.substring(eqsep + 1, varsep + 1);
                                Helpers.doCandidates(candidates, Helpers.nextDomain(param, CandidateType.STATIC_METHOD), curBuf, CandidateType.PACKAGE);
                            }
                        }
                    }
                }
            }
        }

        private boolean completingConstructor(ParsedLine commandLine) {
            return !commandLine.word().contains("(") && (commandLine.wordIndex() == 1 && ((String)commandLine.words().get(0)).matches("(new|\\w+=[{]?new)") || commandLine.wordIndex() > 1 && Helpers.constructorStatement((String)commandLine.words().get(commandLine.wordIndex() - 1)));
        }

        private void doIdentifierCandidates(List<Candidate> candidates, Object object, String curBuf) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            if (map.isEmpty() || !(map.keySet().iterator().next() instanceof String)) {
                return;
            }
            Helpers.doCandidates(candidates, map.keySet(), curBuf, CandidateType.IDENTIFIER);
        }

        private Set<String> doMetaMethodCandidates(List<Candidate> candidates, Object object, String curBuf) {
            ObjectInspector inspector = new ObjectInspector(object);
            List<Map<String, String>> mms = inspector.metaMethods(false);
            HashSet<String> metaMethods = new HashSet<String>();
            for (Map<String, String> mm : mms) {
                metaMethods.add(mm.get("name"));
            }
            Helpers.doCandidates(candidates, metaMethods, curBuf, CandidateType.META_METHOD);
            return metaMethods;
        }

        private void doMethodCandidates(List<Candidate> candidates, Object object, String curBuf) {
            if (object == null) {
                return;
            }
            Set<String> metaMethods = null;
            if (this.identifierCompletion) {
                this.doIdentifierCandidates(candidates, object, curBuf);
            }
            if (this.metaMethodCompletion) {
                metaMethods = this.doMetaMethodCandidates(candidates, object, curBuf);
            }
            this.doMethodCandidates(candidates, object.getClass(), curBuf, this.identifierCompletion && !(object instanceof Map), metaMethods);
        }

        private void doMethodCandidates(List<Candidate> candidates, Class<?> clazz, String curBuf, boolean addIdentifiers, Set<String> metaMethods) {
            if (clazz == null) {
                return;
            }
            Set<String> methods = Helpers.getMethods(clazz, this.access.allMethods);
            if (addIdentifiers) {
                HashSet<String> identifiers = new HashSet<String>();
                block4: for (String m : methods) {
                    if (!m.matches("get[A-Z].*")) continue;
                    for (Class<?> cc = clazz; cc != null; cc = cc.getSuperclass()) {
                        try {
                            try {
                                cc.getMethod(m, new Class[0]);
                            }
                            catch (NoSuchMethodException exp) {
                                cc.getDeclaredMethod(m, new Class[0]);
                            }
                            char[] c = m.substring(3).toCharArray();
                            c[0] = Character.toLowerCase(c[0]);
                            identifiers.add(new String(c));
                            continue block4;
                        }
                        catch (NoSuchMethodException e) {
                            continue;
                        }
                    }
                }
                Helpers.doCandidates(candidates, identifiers, curBuf, CandidateType.IDENTIFIER);
            }
            if (metaMethods != null) {
                for (String mm : metaMethods) {
                    methods.remove(mm);
                }
            }
            Helpers.doCandidates(candidates, methods, curBuf, CandidateType.METHOD);
            Helpers.doCandidates(candidates, Helpers.getFields(clazz, this.access.allFields), curBuf, CandidateType.FIELD);
        }

        private void doStaticMethodCandidates(List<Candidate> candidates, Class<?> clazz, String curBuf) {
            if (clazz == null) {
                return;
            }
            Helpers.doCandidates(candidates, Helpers.getStaticMethods(clazz, this.access.allMethods), curBuf, CandidateType.METHOD);
            Helpers.doCandidates(candidates, Helpers.getStaticFields(clazz, this.access.allFields), curBuf, CandidateType.FIELD);
        }

        private Set<String> retrieveConstructors(boolean all) {
            HashSet<String> out = new HashSet<String>();
            Iterator<Map.Entry<String, Class<?>>> it = this.inspector.nameClass().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Class<?>> entry = it.next();
                Class<?> c = entry.getValue();
                try {
                    if (!all && c.getConstructors().length == 0 || all && c.getDeclaredConstructors().length == 0 || Modifier.isAbstract(c.getModifiers())) continue;
                    out.add(entry.getKey());
                }
                catch (NoClassDefFoundError e) {
                    it.remove();
                }
            }
            return out;
        }

        private Set<String> retrieveClassesWithStaticMethods() {
            HashSet<String> out = new HashSet<String>();
            Iterator<Map.Entry<String, Class<?>>> it = this.inspector.nameClass().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Class<?>> entry = it.next();
                Class<?> c = entry.getValue();
                try {
                    if (Helpers.noStaticMethods(c, this.access.allMethods) && Helpers.noStaticFields(c, this.access.allFields)) continue;
                    out.add(entry.getKey());
                }
                catch (NoClassDefFoundError e) {
                    it.remove();
                }
            }
            return out;
        }
    }

    private static class PackageCompleter
    implements Completer {
        private final CandidateType type;
        private final GroovyEngine groovyEngine;

        public PackageCompleter(CandidateType type, GroovyEngine groovyEngine) {
            this.type = type;
            this.groovyEngine = groovyEngine;
        }

        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            String curBuf = "";
            int lastDelim = buffer.lastIndexOf(46);
            if (lastDelim > -1) {
                curBuf = buffer.substring(0, lastDelim + 1);
            }
            Helpers.doCandidates(candidates, Helpers.nextDomain(curBuf, new AccessRules(this.groovyEngine.groovyOptions()), this.type), curBuf, this.type);
        }
    }

    private static class Helpers {
        private Helpers() {
        }

        private static Set<String> loadedPackages() {
            HashSet<String> out = new HashSet<String>();
            for (Package p : Package.getPackages()) {
                out.add(p.getName());
            }
            return out;
        }

        private static Set<String> names(String domain) {
            HashSet<String> out = new HashSet<String>();
            for (String p : Helpers.loadedPackages()) {
                if (!p.startsWith(domain)) continue;
                int idx = p.indexOf(46, domain.length());
                if (idx < 0) {
                    idx = p.length();
                }
                out.add(p.substring(domain.length(), idx));
            }
            return out;
        }

        public static Set<Method> getClassMethods(Class<?> clazz, boolean all) {
            HashSet<Method> out = new HashSet<Method>(Arrays.asList(clazz.getMethods()));
            if (all) {
                out.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            }
            return out;
        }

        public static Set<String> getMethods(Class<?> clazz, boolean all) {
            return Helpers.getMethods(clazz, all, false, false);
        }

        public static Set<String> getStaticMethods(Class<?> clazz, boolean all) {
            return Helpers.getMethods(clazz, all, true, false);
        }

        public static boolean noStaticMethods(Class<?> clazz, boolean all) {
            return Helpers.getMethods(clazz, all, true, true).isEmpty();
        }

        private static Set<String> getMethods(Class<?> clazz, boolean all, boolean statc, boolean firstOnly) {
            HashSet<String> out = new HashSet<String>();
            try {
                for (Method method : Helpers.getClassMethods(clazz, all)) {
                    if ((!statc || !Modifier.isStatic(method.getModifiers())) && (statc || Modifier.isStatic(method.getModifiers()))) continue;
                    out.add(method.getName());
                    if (!firstOnly) continue;
                    break;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return out;
        }

        public static Map<String, String> getFields(Class<?> clazz, boolean all) {
            return Helpers.getFields(clazz, all, false, false);
        }

        public static Map<String, String> getStaticFields(Class<?> clazz, boolean all) {
            return Helpers.getFields(clazz, all, true, false);
        }

        public static boolean noStaticFields(Class<?> clazz, boolean all) {
            return Helpers.getFields(clazz, all, true, true).isEmpty();
        }

        private static Map<String, String> getFields(Class<?> clazz, boolean all, boolean statc, boolean firstOnly) {
            HashMap<String, String> out = new HashMap<String, String>();
            for (Field field : all ? clazz.getDeclaredFields() : clazz.getFields()) {
                if ((!statc || !Modifier.isStatic(field.getModifiers())) && (statc || Modifier.isStatic(field.getModifiers()))) continue;
                out.put(field.getName(), field.getType().getSimpleName());
                if (firstOnly) break;
            }
            return out;
        }

        public static Set<String> nextDomain(String domain, CandidateType type) {
            return Helpers.nextDomain(domain, new AccessRules(), type);
        }

        public static Set<String> nextDomain(String domain, AccessRules access, CandidateType type) {
            Set<String> out = new HashSet<String>();
            if (domain.isEmpty()) {
                for (String p : Helpers.loadedPackages()) {
                    out.add(p.split("\\.")[0]);
                }
            } else if (domain.split("\\.").length < 2) {
                out = Helpers.names(domain);
            } else {
                try {
                    for (Class c : GroovyEngine.classesForPackage(domain)) {
                        try {
                            if (!Modifier.isPublic(c.getModifiers()) && !access.allClasses || c.getCanonicalName() == null || type == CandidateType.CONSTRUCTOR && (c.getConstructors().length == 0 || Modifier.isAbstract(c.getModifiers())) || type == CandidateType.STATIC_METHOD && Helpers.noStaticMethods(c, access.allMethods) && Helpers.noStaticFields(c, access.allFields)) continue;
                            String name = c.getCanonicalName();
                            Log.debug((Object[])new Object[]{name});
                            if (!name.startsWith(domain)) continue;
                            int idx = name.indexOf(46, domain.length());
                            if (idx < 0) {
                                idx = name.length();
                            }
                            out.add(name.substring(domain.length(), idx));
                        }
                        catch (NoClassDefFoundError e) {
                            if (!Log.isDebugEnabled()) continue;
                            e.printStackTrace();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    out = Helpers.names(domain);
                }
            }
            return out;
        }

        private static Map<String, String> listToMap(Collection<String> list) {
            return list.stream().collect(Collectors.toMap(it -> it, it -> ""));
        }

        public static void doCandidates(List<Candidate> candidates, Collection<String> fields, String curBuf, CandidateType type) {
            Helpers.doCandidates(candidates, Helpers.listToMap(fields), curBuf, type);
        }

        public static void doCandidates(List<Candidate> candidates, Map<String, String> fields, String curBuf, CandidateType type) {
            if (fields == null) {
                return;
            }
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                String group = null;
                String desc = entry.getValue().isEmpty() ? null : entry.getValue();
                String s = entry.getKey();
                if (s == null) continue;
                String postFix = "";
                if (type == CandidateType.CONSTRUCTOR) {
                    if (s.matches("[a-z]+.*")) {
                        postFix = ".";
                    } else if (s.matches("[A-Z]+.*")) {
                        postFix = "(";
                    }
                } else if (type == CandidateType.PACKAGE) {
                    if (s.matches("[a-z]+.*")) {
                        postFix = ".";
                    }
                } else if (type == CandidateType.METHOD) {
                    postFix = "(";
                    group = "Methods";
                } else if (type == CandidateType.FIELD) {
                    group = "Fields";
                } else if (type == CandidateType.IDENTIFIER) {
                    group = "Identifiers";
                    if (s.contains("-") || s.contains("+") || s.contains(" ") || s.contains("#") || !s.matches("[a-zA-Z$_].*")) {
                        continue;
                    }
                } else if (type == CandidateType.META_METHOD) {
                    postFix = "(";
                    group = "MetaMethods";
                }
                candidates.add(new Candidate(AttributedString.stripAnsi((String)(curBuf + s + postFix)), s, group, desc, null, null, false));
            }
        }

        public static int statementBegin(String buffer) {
            String buf = buffer;
            while (buf.matches(".*\\)\\.\\w+$")) {
                int idx = buf.lastIndexOf(".");
                int openingRound = Brackets.indexOfOpeningRound(buf.substring(0, idx));
                buf = buf.substring(0, openingRound);
            }
            return Helpers.statementBegin(new Brackets(buf));
        }

        public static int statementBegin(String buffer, String wordbuffer, Brackets brackets) {
            int out = -1;
            int idx = buffer.lastIndexOf(wordbuffer);
            if (idx > -1) {
                out = Helpers.statementBegin(brackets.lastDelim() - idx, brackets.lastOpenRound() - idx, brackets.lastComma() - idx, brackets.lastOpenCurly() - idx, brackets.lastCloseCurly() - idx, brackets.lastSemicolon() - idx);
            }
            return out;
        }

        private static int statementBegin(Brackets brackets) {
            return Helpers.statementBegin(brackets.lastDelim(), brackets.lastOpenRound(), brackets.lastComma(), brackets.lastOpenCurly(), brackets.lastCloseCurly(), brackets.lastSemicolon());
        }

        private static int statementBegin(int lastDelim, int openRound, int comma, int openCurly, int closeCurly, int semicolon) {
            int out = lastDelim;
            if (openRound > out) {
                out = openRound;
            }
            if (comma > out) {
                out = comma;
            }
            if (openCurly > out) {
                out = openCurly;
            }
            if (closeCurly > out) {
                out = closeCurly;
            }
            if (semicolon > out) {
                out = semicolon;
            }
            return Math.max(out, -1);
        }

        public static boolean constructorStatement(String fragment) {
            return fragment.matches("(.*\\s+new|.*\\(new|.*\\{new|.*=new|.*,new|new)");
        }
    }

    protected static class AccessRules {
        protected final boolean allMethods;
        protected final boolean allFields;
        protected final boolean allConstructors;
        protected final boolean allClasses;

        public AccessRules() {
            this(new HashMap<String, Object>());
        }

        public AccessRules(Map<String, Object> options) {
            this.allMethods = GroovyEngine.groovyOption(options, GroovyEngine.ALL_METHODS_COMPLETION, false);
            this.allFields = GroovyEngine.groovyOption(options, GroovyEngine.ALL_FIELDS_COMPLETION, false);
            this.allConstructors = GroovyEngine.groovyOption(options, GroovyEngine.ALL_CONSTRUCTORS_COMPLETION, false);
            this.allClasses = GroovyEngine.groovyOption(options, GroovyEngine.ALL_CLASSES_COMPLETION, false);
        }
    }

    private static enum CandidateType {
        CONSTRUCTOR,
        STATIC_METHOD,
        PACKAGE,
        METHOD,
        FIELD,
        IDENTIFIER,
        META_METHOD,
        OTHER;

    }

    public static interface Cloner {
        public Object clone(Object var1);

        public void markCache();

        public void purgeCache();
    }

    public static enum Format {
        JSON,
        GROOVY,
        NONE;

    }
}

