/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageHelper {
    private static void checkDirectory(File directory, String pckgname, List<Class<?>> classes, ClassesToScann scann) {
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            for (String file : files != null ? files : new String[]{}) {
                File tmpDirectory;
                if (file.endsWith(".class")) {
                    PackageHelper.addClass(pckgname + '.' + file.substring(0, file.length() - 6), classes);
                    continue;
                }
                if (scann != ClassesToScann.ALL || !(tmpDirectory = new File(directory, file)).isDirectory()) continue;
                PackageHelper.checkDirectory(tmpDirectory, pckgname + "." + file, classes, ClassesToScann.ALL);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String pckgname, List<Class<?>> classes, ClassesToScann scann) throws IOException {
        JarEntry jarEntry;
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class")) continue;
            name = name.substring(0, name.length() - 6).replace('/', '.');
            if (scann != ClassesToScann.ALL) {
                String namepckg = name.substring(0, name.lastIndexOf("."));
                if (!pckgname.equals(namepckg) || (scann != ClassesToScann.PACKAGE_CLASS || name.contains("$")) && scann != ClassesToScann.PACKAGE_ALL) continue;
                PackageHelper.addClass(name, classes);
                continue;
            }
            if (!name.contains(pckgname)) continue;
            PackageHelper.addClass(name, classes);
        }
    }

    private static void addClass(String className, List<Class<?>> classes) {
        try {
            classes.add(Class.forName(className));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        ClassesToScann scann = ClassesToScann.ALL;
        if (pckgname.endsWith(".*")) {
            scann = ClassesToScann.PACKAGE_CLASS;
            pckgname = pckgname.substring(0, pckgname.length() - 2);
        } else if (pckgname.endsWith(".**")) {
            pckgname = pckgname.substring(0, pckgname.length() - 3);
            scann = ClassesToScann.PACKAGE_ALL;
        }
        try {
            URL url;
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        PackageHelper.checkJarFile((JarURLConnection)connection, pckgname, classes, scann);
                        continue;
                    }
                    if (!connection.getClass().getCanonicalName().equals("sun.net.www.protocol.file.FileURLConnection")) throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package");
                    try {
                        PackageHelper.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), pckgname, classes, scann);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException ioex) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
        }
    }

    private static enum ClassesToScann {
        ALL,
        PACKAGE_ALL,
        PACKAGE_CLASS;

    }
}

