/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.console.ui.Console;
import groovy.console.ui.ObjectBrowser;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.builtins.Completers;
import org.jline.console.CmdDesc;
import org.jline.console.CommandInput;
import org.jline.console.CommandMethods;
import org.jline.console.CommandRegistry;
import org.jline.console.Printer;
import org.jline.console.impl.AbstractCommandRegistry;
import org.jline.groovy.ObjectInspector;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.script.GroovyEngine;
import org.jline.utils.AttributedString;

public class GroovyCommand
extends AbstractCommandRegistry
implements CommandRegistry {
    private static final String DEFAULT_NANORC_VALUE = "classpath:/org/jline/groovy/gron.nanorc";
    private final GroovyEngine engine;
    private final Printer printer;
    private final Map<Command, CmdDesc> commandDescs = new HashMap<Command, CmdDesc>();
    private final Map<Command, List<String>> commandInfos = new HashMap<Command, List<String>>();
    private boolean consoleUi;
    private boolean ivy;

    public GroovyCommand(GroovyEngine engine, Printer printer) {
        this(null, engine, printer);
    }

    public GroovyCommand(Set<Command> commands, GroovyEngine engine, Printer printer) {
        this.engine = engine;
        this.printer = printer;
        try {
            Class.forName("groovy.console.ui.ObjectBrowser");
            this.consoleUi = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("org.apache.ivy.util.Message");
            System.setProperty("groovy.grape.report.downloads", "false");
            this.ivy = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<Command, String> commandName = new HashMap<Command, String>();
        HashMap<Command, CommandMethods> commandExecute = new HashMap<Command, CommandMethods>();
        HashSet<Command> cmds = commands == null ? new HashSet<Command>(EnumSet.allOf(Command.class)) : new HashSet<Command>(commands);
        if (!this.consoleUi) {
            cmds.remove((Object)Command.CONSOLE);
        }
        if (!this.ivy) {
            cmds.remove((Object)Command.GRAB);
        }
        for (Command c : cmds) {
            commandName.put(c, c.name().toLowerCase());
        }
        commandExecute.put(Command.INSPECT, new CommandMethods(this::inspect, this::inspectCompleter));
        commandExecute.put(Command.CONSOLE, new CommandMethods(this::console, this::defaultCompleter));
        commandExecute.put(Command.GRAB, new CommandMethods(this::grab, this::defaultCompleter));
        commandExecute.put(Command.CLASSLOADER, new CommandMethods(this::classLoader, this::classloaderCompleter));
        this.registerCommands(commandName, commandExecute);
        this.commandDescs.put(Command.INSPECT, this.inspectCmdDesc());
        this.commandDescs.put(Command.CONSOLE, this.consoleCmdDesc());
        this.commandDescs.put(Command.GRAB, this.grabCmdDesc());
        this.commandDescs.put(Command.CLASSLOADER, this.classLoaderCmdDesc());
    }

    public List<String> commandInfo(String command) {
        Command cmd = (Command)((Object)this.registeredCommand(command));
        return this.commandInfos.get((Object)cmd);
    }

    public CmdDesc commandDescription(List<String> args) {
        String command = args != null && !args.isEmpty() ? args.get(0) : "";
        Command cmd = (Command)((Object)this.registeredCommand(command));
        return this.commandDescs.get((Object)cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object grab(CommandInput input) {
        if (input.xargs().length == 0) {
            return null;
        }
        if (input.args().length > 2) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        try {
            String arg = input.args()[0];
            if (arg.equals("-?") || arg.equals("--help")) {
                this.printer.println((Object)this.helpDesc(Command.GRAB));
            } else if (arg.equals("-l") || arg.equals("--list")) {
                Object resp = this.engine.execute("groovy.grape.Grape.getInstance().enumerateGrapes()");
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("skipDefaultOptions", true);
                options.put("maxDepth", 1);
                options.put("indention", 4);
                options.put("valueStyle", this.engine.groovyOption("nanorcValue", DEFAULT_NANORC_VALUE));
                this.printer.println(options, resp);
            } else {
                int artifactId = 0;
                if (input.args().length == 2) {
                    if (input.args()[0].equals("-v") || input.args()[0].equals("--verbose")) {
                        System.setProperty("groovy.grape.report.downloads", "true");
                        artifactId = 1;
                    } else if (input.args()[1].equals("-v") || input.args()[1].equals("--verbose")) {
                        System.setProperty("groovy.grape.report.downloads", "true");
                    } else {
                        throw new IllegalArgumentException("Unknown command parameters!");
                    }
                }
                Map<String, String> artifact = new HashMap();
                Object xarg = input.xargs()[artifactId];
                if (xarg instanceof String) {
                    String[] vals = input.args()[artifactId].split(":");
                    if (vals.length != 3) {
                        throw new IllegalArgumentException("Invalid command parameter: " + input.args()[artifactId]);
                    }
                    artifact.put("group", vals[0]);
                    artifact.put("module", vals[1]);
                    artifact.put("version", vals[2]);
                } else if (xarg instanceof Map) {
                    artifact = (Map)xarg;
                } else {
                    throw new IllegalArgumentException("Unknown command parameter: " + xarg);
                }
                this.engine.put("_artifact", artifact);
                this.engine.execute("groovy.grape.Grape.grab(_artifact)");
            }
        }
        catch (Exception e) {
            this.saveException(e);
        }
        finally {
            System.setProperty("groovy.grape.report.downloads", "false");
        }
        return null;
    }

    public void console(CommandInput input) {
        if (input.args().length > 1) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        if (input.args().length == 1) {
            String arg = input.args()[0];
            if (arg.equals("-?") || arg.equals("--help")) {
                this.printer.println((Object)this.helpDesc(Command.CONSOLE));
                return;
            }
            throw new IllegalArgumentException("Unknown command parameter: " + input.args()[0]);
        }
        Console c = new Console(this.engine.sharedData);
        c.run();
    }

    public Object inspect(CommandInput input) {
        String option;
        if (input.xargs().length == 0) {
            return null;
        }
        if (input.args().length > 2) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        int idx = this.optionIdx(input.args());
        String string = option = idx < 0 ? "--info" : input.args()[idx];
        if (option.equals("-?") || option.equals("--help")) {
            this.printer.println((Object)this.helpDesc(Command.INSPECT));
            return null;
        }
        int id = 0;
        if (idx >= 0) {
            int n = id = idx == 0 ? 1 : 0;
        }
        if (input.args().length < id + 1) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        try {
            Object obj = input.xargs()[id];
            ObjectInspector inspector = new ObjectInspector(obj);
            Object out = null;
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (option.equals("-m") || option.equals("--methods")) {
                out = inspector.methods();
                options.put("columns", ObjectInspector.METHOD_COLUMNS);
            } else if (option.equals("-n") || option.equals("--metaMethods")) {
                out = inspector.metaMethods();
                options.put("columns", ObjectInspector.METHOD_COLUMNS);
            } else if (option.equals("-i") || option.equals("--info")) {
                out = inspector.properties();
                options.put("valueStyle", this.engine.groovyOption("nanorcValue", DEFAULT_NANORC_VALUE));
            } else if (this.consoleUi && (option.equals("-g") || option.equals("--gui"))) {
                ObjectBrowser.inspect((Object)obj);
            } else {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            options.put("skipDefaultOptions", true);
            options.put("maxDepth", 1);
            options.put("indention", 4);
            this.printer.println(options, out);
        }
        catch (Exception e) {
            this.saveException(e);
        }
        return null;
    }

    private Object classLoader(CommandInput input) {
        if (input.args().length > 2) {
            throw new IllegalArgumentException("Wrong number of command parameters: " + input.args().length);
        }
        String option = "--view";
        String arg = null;
        if (input.args().length > 0) {
            String[] args = input.args();
            int idx = this.optionIdx(args);
            String string = option = idx > -1 ? args[idx] : "--view";
            if (option.contains("=")) {
                arg = option.substring(option.indexOf("=") + 1);
                option = option.substring(0, option.indexOf("="));
            } else if (input.args().length == 2 && idx > -1) {
                arg = idx == 0 ? args[1] : args[0];
            }
        }
        try {
            switch (option) {
                case "-?": 
                case "--help": {
                    this.printer.println((Object)this.helpDesc(Command.CLASSLOADER));
                    break;
                }
                case "-v": 
                case "--view": {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("skipDefaultOptions", true);
                    options.put("valueStyle", this.engine.groovyOption("nanorcValue", DEFAULT_NANORC_VALUE));
                    options.put("maxDepth", 1);
                    options.put("indention", 4);
                    options.put("columns", Arrays.asList("loadedClasses", "definedPackages", "classPath"));
                    this.printer.println(options, (Object)this.engine.classLoader);
                    break;
                }
                case "-d": 
                case "--delete": {
                    this.engine.purgeClassCache(arg != null ? arg.replace("*", ".*") : null);
                    break;
                }
                case "-a": 
                case "--add": {
                    File file;
                    File file2 = file = arg != null ? new File(arg) : null;
                    if (file == null || !file.exists()) {
                        throw new IllegalArgumentException("Bad or missing argument!");
                    }
                    if (file.isDirectory()) {
                        String separator = FileSystems.getDefault().getSeparator();
                        if (separator.equals("\\") && !arg.contains("\\") && arg.contains("/")) {
                            arg = arg.replace("/", "\\");
                        }
                        if (arg.endsWith(separator)) {
                            separator = "";
                        }
                        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("regex:" + arg.replace("\\", "\\\\").replace(".", "\\.") + separator.replace("\\", "\\\\") + ".*\\.jar");
                        Files.walk(Paths.get(arg, new String[0]), new FileVisitOption[0]).filter(matcher::matches).map(Path::toString).forEach(arg_0 -> ((GroovyEngine.EngineClassLoader)this.engine.classLoader).addClasspath(arg_0));
                        break;
                    }
                    this.engine.classLoader.addClasspath(arg);
                }
            }
        }
        catch (Exception exp) {
            this.saveException(exp);
        }
        return null;
    }

    private CmdDesc helpDesc(Command command) {
        return this.doHelpDesc(command.toString().toLowerCase(), this.commandInfos.get((Object)command), this.commandDescs.get((Object)command));
    }

    private CmdDesc grabCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        optDescs.put("-l --list", this.doDescription("List the modules in the cache"));
        optDescs.put("-v --verbose", this.doDescription("Report downloads"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Add maven repository dependencies to classpath");
        this.commandInfos.put(Command.GRAB, info);
        mainDesc.add(new AttributedString((CharSequence)"grab [OPTIONS] <group>:<artifact>:<version>"));
        mainDesc.add(new AttributedString((CharSequence)"grab --list"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private CmdDesc consoleCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Launch Groovy console");
        this.commandInfos.put(Command.CONSOLE, info);
        mainDesc.add(new AttributedString((CharSequence)"console"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private CmdDesc inspectCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        if (this.consoleUi) {
            optDescs.put("-g --gui", this.doDescription("Launch object browser"));
        }
        optDescs.put("-i --info", this.doDescription("Object class info"));
        optDescs.put("-m --methods", this.doDescription("List object methods"));
        optDescs.put("-n --metaMethods", this.doDescription("List object metaMethods"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Display object info on terminal");
        this.commandInfos.put(Command.INSPECT, info);
        mainDesc.add(new AttributedString((CharSequence)"inspect [OPTION] OBJECT"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private CmdDesc classLoaderCmdDesc() {
        HashMap<String, List<AttributedString>> optDescs = new HashMap<String, List<AttributedString>>();
        optDescs.put("-? --help", this.doDescription("Displays command help"));
        optDescs.put("-v --view", this.doDescription("View class loader info"));
        optDescs.put("-d --delete [REGEX]", this.doDescription("Delete loaded classes"));
        optDescs.put("-a --add PATH", this.doDescription("Add classpath PATH - a jar file or a directory"));
        CmdDesc out = new CmdDesc(new ArrayList(), optDescs);
        ArrayList<AttributedString> mainDesc = new ArrayList<AttributedString>();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Display and manage Groovy classLoader data");
        this.commandInfos.put(Command.CLASSLOADER, info);
        mainDesc.add(new AttributedString((CharSequence)"classloader"));
        out.setMainDesc(mainDesc);
        out.setHighlighted(false);
        return out;
    }

    private List<AttributedString> doDescription(String description) {
        ArrayList<AttributedString> out = new ArrayList<AttributedString>();
        out.add(new AttributedString((CharSequence)description));
        return out;
    }

    private int optionIdx(String[] args) {
        int out = 0;
        for (String a : args) {
            if (a.startsWith("-")) {
                return out;
            }
            ++out;
        }
        return -1;
    }

    private List<String> variables() {
        ArrayList<String> out = new ArrayList<String>();
        for (String v : this.engine.find(null).keySet()) {
            out.add("$" + v);
        }
        return out;
    }

    private List<Completers.OptDesc> compileOptDescs(String command) {
        ArrayList<Completers.OptDesc> out = new ArrayList<Completers.OptDesc>();
        Command cmd = Command.valueOf(command.toUpperCase());
        for (Map.Entry entry : this.commandDescs.get((Object)cmd).getOptsDesc().entrySet()) {
            String[] option = ((String)entry.getKey()).split("\\s+");
            String desc = ((AttributedString)((List)entry.getValue()).get(0)).toString();
            if (option.length == 2) {
                out.add(new Completers.OptDesc(option[0], option[1], desc));
                continue;
            }
            if (option[0].charAt(1) == '-') {
                out.add(new Completers.OptDesc(null, option[0], desc));
                continue;
            }
            out.add(new Completers.OptDesc(option[0], null, desc));
        }
        return out;
    }

    private List<Completer> classloaderCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        List<NullCompleter> argsCompleters = Collections.singletonList(NullCompleter.INSTANCE);
        ArrayList<Completers.OptDesc> options = new ArrayList<Completers.OptDesc>();
        options.add(new Completers.OptDesc("-?", "--help", (Completer)NullCompleter.INSTANCE));
        options.add(new Completers.OptDesc("-a", "--add", (Completer)new Completers.FilesCompleter(new File("."), "*.jar")));
        options.add(new Completers.OptDesc("-d", "--delete", (Completer)NullCompleter.INSTANCE));
        options.add(new Completers.OptDesc("-v", "--view", (Completer)NullCompleter.INSTANCE));
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter(argsCompleters, options, 1)});
        out.add((Completer)ac);
        return out;
    }

    private List<Completer> inspectCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter(Arrays.asList(new StringsCompleter(this::variables), NullCompleter.INSTANCE), this::compileOptDescs, 1)});
        out.add((Completer)ac);
        return out;
    }

    private List<Completer> defaultCompleter(String command) {
        ArrayList<Completer> out = new ArrayList<Completer>();
        ArgumentCompleter ac = new ArgumentCompleter(new Completer[]{NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::compileOptDescs, 1)});
        out.add((Completer)ac);
        return out;
    }

    public static enum Command {
        INSPECT,
        CONSOLE,
        GRAB,
        CLASSLOADER;

    }
}

