/*
 * Decompiled with CFR 0.152.
 */
package org.jline.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageHelper {
    private static void checkDirectory(File directory, String pckgname, List<Object> classes, ClassesToScann scann, ClassOutput outType, Function<String, Class<?>> classResolver) {
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            for (String file : files != null ? files : new String[]{}) {
                File tmpDirectory;
                if (file.endsWith(".class")) {
                    String className = pckgname + '.' + file.substring(0, file.length() - 6);
                    if (outType != ClassOutput.CLASS) {
                        classes.add(className);
                        continue;
                    }
                    PackageHelper.addClass(className, classes, classResolver);
                    continue;
                }
                if (scann != ClassesToScann.ALL || !(tmpDirectory = new File(directory, file)).isDirectory()) continue;
                PackageHelper.checkDirectory(tmpDirectory, pckgname + "." + file, classes, ClassesToScann.ALL, ClassOutput.NAME, classResolver);
            }
        }
    }

    private static void checkJarFile(JarFile jarFile, String pckgname, List<Object> classes, ClassesToScann scann, ClassOutput outType, Function<String, Class<?>> classResolver) throws IOException {
        JarEntry jarEntry;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class")) continue;
            name = name.substring(0, name.length() - 6).replace('/', '.');
            if (scann != ClassesToScann.ALL) {
                String namepckg = name.substring(0, name.lastIndexOf("."));
                if (!pckgname.equals(namepckg) || (scann != ClassesToScann.PACKAGE_CLASS || name.contains("$")) && scann != ClassesToScann.PACKAGE_ALL) continue;
                if (outType == ClassOutput.CLASS) {
                    PackageHelper.addClass(name, classes, classResolver);
                    continue;
                }
                classes.add(name);
                continue;
            }
            if (!name.contains(pckgname)) continue;
            if (outType == ClassOutput.CLASS || outType == ClassOutput.MIXED && Character.isUpperCase(name.charAt(pckgname.length() + 1))) {
                PackageHelper.addClass(name, classes, classResolver);
                continue;
            }
            classes.add(name);
        }
    }

    private static void addClass(String className, List<Object> classes, Function<String, Class<?>> classResolver) {
        if (classResolver != null) {
            Class<?> clazz = classResolver.apply(className);
            if (clazz != null) {
                classes.add(clazz);
            }
        } else {
            classes.add(className);
        }
    }

    private static Class<?> classResolver(String name) {
        Class<?> out = null;
        try {
            out = Class.forName(name);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        return out;
    }

    private static Enumeration<URL> toEnumeration(final URL[] urls) {
        return new Enumeration<URL>(){
            final int size;
            int cursor;
            {
                this.size = urls.length;
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            @Override
            public URL nextElement() {
                return urls[this.cursor++];
            }
        };
    }

    private static Enumeration<URL> getResources(ClassLoader classLoader, String packageName) throws ClassNotFoundException {
        try {
            return classLoader.getResources(packageName.replace('.', '/'));
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, ioex);
        }
    }

    public static List<String> getClassNamesForPackage(String pckgname, ClassLoader classLoader) {
        try {
            PackageNameParser pnp = new PackageNameParser(pckgname);
            Enumeration<URL> resources = PackageHelper.getResources(classLoader, pnp.packageName());
            return PackageHelper.getClassesForPackage(pnp.packageName(), resources, pnp.classesToScann(), ClassOutput.NAME, null);
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public static List<Object> getClassesForPackage(String pckgname, GroovyClassLoader classLoader, Function<String, Class<?>> classResolver) throws ClassNotFoundException {
        PackageNameParser pnp = new PackageNameParser(pckgname);
        Enumeration<URL> resources = PackageHelper.toEnumeration(classLoader.getURLs());
        return PackageHelper.getClassesForPackage(pnp.packageName(), resources, pnp.classesToScann(), pnp.outType(), classResolver);
    }

    public static List<Object> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            throw new ClassNotFoundException("Can't get class loader.");
        }
        PackageNameParser pnp = new PackageNameParser(pckgname);
        Enumeration<URL> resources = PackageHelper.getResources(cld, pnp.packageName());
        return PackageHelper.getClassesForPackage(pnp.packageName(), resources, pnp.classesToScann(), pnp.outType(), PackageHelper::classResolver);
    }

    private static List<Object> getClassesForPackage(String pckgname, Enumeration<URL> resources, ClassesToScann scann, ClassOutput outType, Function<String, Class<?>> classResolver) throws ClassNotFoundException {
        URL url;
        ArrayList<Object> classes = new ArrayList<Object>();
        while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
            try {
                URLConnection connection = url.openConnection();
                if (connection instanceof JarURLConnection) {
                    PackageHelper.checkJarFile(((JarURLConnection)connection).getJarFile(), pckgname, classes, scann, outType, classResolver);
                    continue;
                }
                if (connection.getClass().getCanonicalName().equals("sun.net.www.protocol.file.FileURLConnection")) {
                    try {
                        File file = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
                        if (!file.exists()) continue;
                        if (file.isDirectory()) {
                            PackageHelper.checkDirectory(file, pckgname, classes, scann, outType, classResolver);
                            continue;
                        }
                        if (!file.getName().endsWith(".jar")) continue;
                        PackageHelper.checkJarFile(new JarFile(file), pckgname, classes, scann, outType, classResolver);
                        continue;
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package");
            }
            catch (IOException ioex) {
                throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
            }
        }
        return classes;
    }

    private static enum ClassOutput {
        NAME,
        CLASS,
        MIXED;

    }

    private static enum ClassesToScann {
        ALL,
        PACKAGE_ALL,
        PACKAGE_CLASS;

    }

    private static class PackageNameParser {
        private final String packageName;
        private final ClassesToScann classesToScann;
        private final ClassOutput outType;

        public PackageNameParser(String packageName) {
            if (packageName.endsWith(".*")) {
                this.classesToScann = ClassesToScann.PACKAGE_CLASS;
                this.outType = ClassOutput.CLASS;
                this.packageName = packageName.substring(0, packageName.length() - 2);
            } else if (packageName.endsWith(".**")) {
                this.packageName = packageName.substring(0, packageName.length() - 3);
                this.classesToScann = ClassesToScann.PACKAGE_ALL;
                this.outType = ClassOutput.CLASS;
            } else {
                this.classesToScann = ClassesToScann.ALL;
                this.packageName = packageName;
                this.outType = ClassOutput.MIXED;
            }
        }

        public String packageName() {
            return this.packageName;
        }

        public ClassesToScann classesToScann() {
            return this.classesToScann;
        }

        public ClassOutput outType() {
            return this.outType;
        }
    }
}

