/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi.win;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.IntConsumer;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jline.terminal.Cursor;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jansi.win.WindowsAnsiOutputStream;
import org.jline.utils.InfoCmp;

public class JansiWinSysTerminal
extends AbstractWindowsTerminal {
    public JansiWinSysTerminal(String name, boolean nativeSignals) throws IOException {
        this(name, 0, nativeSignals, Terminal.SignalHandler.SIG_DFL);
    }

    public JansiWinSysTerminal(String name, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super((OutputStream)((Object)new WindowsAnsiOutputStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)))), name, codepage, nativeSignals, signalHandler);
    }

    protected int getConsoleOutputCP() {
        return Kernel32.GetConsoleOutputCP();
    }

    protected void setConsoleOutputCP(int cp) {
        Kernel32.SetConsoleOutputCP((int)cp);
    }

    protected int getConsoleMode() {
        return WindowsSupport.getConsoleMode();
    }

    protected void setConsoleMode(int mode) {
        WindowsSupport.setConsoleMode((int)mode);
    }

    public Size getSize() {
        Size size = new Size();
        size.setColumns(WindowsSupport.getWindowsTerminalWidth());
        size.setRows(WindowsSupport.getWindowsTerminalHeight());
        return size;
    }

    protected String readConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD[] events = WindowsSupport.readConsoleInput((int)1);
        if (events == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            Kernel32.KEY_EVENT_RECORD keyEvent = event.keyEvent;
            sb.append(this.getEscapeSequenceFromConsoleInput(keyEvent.keyDown, keyEvent.keyCode, keyEvent.uchar, keyEvent.controlKeyState, keyEvent.repeatCount, keyEvent.scanCode));
        }
        return sb.toString();
    }

    public Cursor getCursorPosition(IntConsumer discarded) {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        long console = Kernel32.GetStdHandle((int)Kernel32.STD_OUTPUT_HANDLE);
        if (Kernel32.GetConsoleScreenBufferInfo((long)console, (Kernel32.CONSOLE_SCREEN_BUFFER_INFO)info) == 0) {
            throw new IOError(new IOException("Could not get the cursor position: " + WindowsSupport.getLastErrorMessage()));
        }
        return new Cursor((int)info.cursorPosition.x, (int)info.cursorPosition.y);
    }

    public void disableScrolling() {
        this.strings.remove(InfoCmp.Capability.insert_line);
        this.strings.remove(InfoCmp.Capability.parm_insert_line);
        this.strings.remove(InfoCmp.Capability.delete_line);
        this.strings.remove(InfoCmp.Capability.parm_delete_line);
    }
}

