/*
 * Decompiled with CFR 0.152.
 */
package org.jmanikin.example.bank;

import org.jmanikin.core.Id;
import org.jmanikin.core.Msg;
import org.jmanikin.message.LocalMessage;

public interface AccountModule {

    public static class Withdraw
    implements AccountMsg {
        public final Double amount;

        public Withdraw(Double amount) {
            this.amount = amount;
        }

        @Override
        public Msg<ID, Account, Void> local() {
            return this.pre(() -> this.amount > 0.0 && ((Account)this.obj()).balance >= this.amount).app(() -> new Account(((Account)this.obj()).balance - this.amount)).eff(() -> null).pst(() -> ((Account)this.obj()).balance == ((Account)this.old()).balance - this.amount);
        }
    }

    public static class Deposit
    implements AccountMsg {
        public final Double amount;

        public Deposit(Double amount) {
            this.amount = amount;
        }

        @Override
        public Msg<ID, Account, Void> local() {
            return this.pre(() -> this.amount > 0.0).app(() -> new Account(((Account)this.obj()).balance + this.amount)).eff(() -> null).pst(() -> ((Account)this.obj()).balance == ((Account)this.old()).balance + this.amount);
        }
    }

    public static class Open
    implements AccountMsg {
        public final Double initial;

        public Open(Double initial) {
            this.initial = initial;
        }

        @Override
        public Msg<ID, Account, Void> local() {
            return this.pre(() -> this.initial >= 0.0).app(() -> new Account(this.initial)).eff(() -> null).pst(() -> ((Account)this.obj()).balance == this.initial);
        }
    }

    public static interface AccountMsg
    extends LocalMessage<ID, Account, Void> {
    }

    public static class Account {
        public final Double balance;

        public Account(Double balance) {
            this.balance = balance;
        }
    }

    public static class ID
    implements Id<Account> {
        public final String id;

        public ID(String id) {
            this.id = id;
        }

        @Override
        public Account init() {
            return new Account(0.0);
        }
    }
}

