/*
 * Decompiled with CFR 0.152.
 */
package org.jmanikin.example.bank;

import org.jmanikin.core.Id;
import org.jmanikin.core.Msg;
import org.jmanikin.example.bank.AccountModule;
import org.jmanikin.message.LocalMessage;

public interface TransferModule {

    public static class Book
    implements TransferMsg {
        public final AccountModule.ID from;
        public final AccountModule.ID to;
        public final Double amount;

        public Book(AccountModule.ID from, AccountModule.ID to, Double amount) {
            this.from = from;
            this.to = to;
            this.amount = amount;
        }

        @Override
        public Msg<ID, Transfer, Void> local() {
            return this.pre(() -> this.amount > 0.0 && this.from != this.to).app(() -> new Transfer(this.from, this.to, this.amount)).eff(() -> {
                this.send(this.from, new AccountModule.Withdraw(this.amount));
                return this.send(this.to, new AccountModule.Deposit(this.amount));
            }).pst(() -> this.obj(this.from).balance + this.obj(this.to).balance == this.old(this.from).balance + this.old(this.to).balance);
        }
    }

    public static interface TransferMsg
    extends LocalMessage<ID, Transfer, Void> {
    }

    public static class Transfer {
        public final AccountModule.ID from;
        public final AccountModule.ID to;
        public final Double amount;

        public Transfer(AccountModule.ID from, AccountModule.ID to, Double amount) {
            this.from = from;
            this.to = to;
            this.amount = amount;
        }
    }

    public static class ID
    implements Id<Transfer> {
        public final Long id;

        public ID(Long id) {
            this.id = id;
        }

        @Override
        public Transfer init() {
            return new Transfer(null, null, 0.0);
        }
    }
}

