/*
 * Decompiled with CFR 0.152.
 */
package org.jmanikin.message;

import java.util.function.Supplier;
import org.jmanikin.core.Apply;
import org.jmanikin.core.Effect;
import org.jmanikin.core.Environment;
import org.jmanikin.core.Id;
import org.jmanikin.core.Message;
import org.jmanikin.core.Msg;
import org.jmanikin.core.PostCondition;
import org.jmanikin.core.PreCondition;

public interface LocalMessage<I extends Id<O>, O, E>
extends Message<I, O, E>,
Environment<I, O, E> {
    public static final ThreadLocal<Object> localEnv = new ThreadLocal();

    default public LocalEnvironment<I, O, E> env() {
        return (LocalEnvironment)localEnv.get();
    }

    public Msg<I, O, E> local();

    @Override
    default public Msg<I, O, E> msg(Environment<I, O, E> e) {
        localEnv.set(new LocalEnvironment<I, O, E>(e));
        return this.local();
    }

    @Override
    default public I self() {
        return this.env().self();
    }

    @Override
    default public O obj() {
        return this.env().obj();
    }

    @Override
    default public O old() {
        return this.env().old();
    }

    @Override
    default public <O2> O2 obj(Id<? extends O2> id) {
        return this.env().obj(id);
    }

    @Override
    default public <O2> O2 old(Id<? extends O2> id) {
        return this.env().old(id);
    }

    @Override
    default public Apply<I, O, E> pre(Supplier<Boolean> pre) {
        return this.env().pre(pre);
    }

    @Override
    default public <I2 extends Id<O2>, O2, R2> R2 send(I2 id, Message<I2, O2, R2> msg) {
        return this.env().send(id, msg);
    }

    public static class LocalEnvironment<I extends Id<O>, O, E>
    implements Environment<I, O, E>,
    PreCondition<I, O, E>,
    Apply<I, O, E>,
    Effect<I, O, E>,
    PostCondition<I, O, E>,
    Msg<I, O, E> {
        private final Environment<I, O, E> env;
        private Supplier<Boolean> _pre;
        private Supplier<O> _app;
        private Supplier<E> _eff;
        private Supplier<Boolean> _pst;

        public LocalEnvironment(Environment<I, O, E> env) {
            this.env = env;
        }

        @Override
        public I self() {
            return this.env.self();
        }

        @Override
        public O obj() {
            return this.env.obj();
        }

        @Override
        public O old() {
            return this.env.old();
        }

        @Override
        public <O2> O2 obj(Id<? extends O2> id) {
            return this.env.obj(id);
        }

        @Override
        public <O2> O2 old(Id<? extends O2> id) {
            return this.env.old(id);
        }

        @Override
        public <I2 extends Id<O2>, O2, R2> R2 send(I2 id, Message<I2, O2, R2> msg) {
            try {
                localEnv.set(this);
                R2 result = this.env.send(id, msg);
                localEnv.set(this);
                return result;
            }
            catch (Exception e) {
                localEnv.set(this);
                throw e;
            }
        }

        @Override
        public Apply<I, O, E> pre(Supplier<Boolean> pre) {
            this._pre = this.injectEnv(pre);
            return this;
        }

        @Override
        public Effect<I, O, E> app(Supplier<O> app) {
            this._app = this.injectEnv(app);
            return this;
        }

        @Override
        public PostCondition<I, O, E> eff(Supplier<E> eff) {
            this._eff = this.injectEnv(eff);
            return this;
        }

        @Override
        public Msg<I, O, E> pst(Supplier<Boolean> pst) {
            this._pst = this.injectEnv(pst);
            return this;
        }

        @Override
        public Supplier<Boolean> pre() {
            return this._pre;
        }

        @Override
        public Supplier<O> app() {
            return this._app;
        }

        @Override
        public Supplier<E> eff() {
            return this._eff;
        }

        @Override
        public Supplier<Boolean> pst() {
            return this._pst;
        }

        private <X> Supplier<X> injectEnv(Supplier<X> s) {
            return () -> {
                localEnv.set(this);
                Object get = s.get();
                localEnv.set(this);
                return get;
            };
        }
    }
}

