/*
 * Decompiled with CFR 0.152.
 */
package org.jmanikin.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jmanikin.core.Id;
import org.jmanikin.core.World;
import org.jmanikin.test.ConformanceResult;
import org.jmanikin.test.TestModule;

public interface WorldTest<W extends World<W>>
extends TestModule,
ConformanceResult {
    default public List<ConformanceResult.WorldConformanceError<W>> check(W w) {
        ArrayList<ConformanceResult.WorldConformanceError<W>> result = new ArrayList<ConformanceResult.WorldConformanceError<W>>();
        result.addAll(this.checkObj(w.init()));
        result.addAll(this.checkOld(w.init()));
        result.addAll(this.checkDeterminism(w.init()));
        result.addAll(this.checkSend(w.init()));
        result.addAll(this.checkRollback(w.init()));
        return result;
    }

    default public void error(String error) {
        throw new RuntimeException(error);
    }

    default public List<ConformanceResult.WorldConformanceError<W>> checkObj(W world) {
        try {
            TestModule.CId a = new TestModule.CId(1);
            TestModule.CId b = new TestModule.CId(2);
            world = world.send((TestModule.CId)a, new TestModule.CopyId()).send(b, new TestModule.LocalCopyId()).world();
            if (world.obj((Id<TestModule.CObject>)a).value().member != 1) {
                this.error("obj(a).value.member should be 1");
            }
            if (world.obj((Id<TestModule.CObject>)b).value().member != 2) {
                this.error("obj(b).value.member should be 2");
            }
        }
        catch (Exception e) {
            return Collections.singletonList(new ConformanceResult.WorldConformanceError<W>(e, new ConformanceResult.ObjProblem(), world));
        }
        return Collections.emptyList();
    }

    default public List<ConformanceResult.WorldConformanceError<W>> checkOld(W world) {
        try {
            TestModule.CId a = new TestModule.CId(1);
            TestModule.CId b = new TestModule.CId(2);
            world = world.send((TestModule.CId)a, new TestModule.SetMember(10)).send(a, new TestModule.SetMember(20)).world();
            if (world.old((Id<TestModule.CObject>)a).value().member != 10) {
                this.error("old(a).value.member should be 10");
            }
            if (world.obj((Id<TestModule.CObject>)a).value().member != 20) {
                this.error("obj(a).value.member should be 20");
            }
            world = world.send((TestModule.CId)b, new TestModule.SetMember(100)).send(b, new TestModule.SetMember(200)).world();
            if (world.old((Id<TestModule.CObject>)b).value().member != 100) {
                this.error("old(b).value.member should be 100");
            }
            if (world.obj((Id<TestModule.CObject>)b).value().member != 200) {
                this.error("obj(b).value.member should be 200");
            }
        }
        catch (Exception e) {
            return Collections.singletonList(new ConformanceResult.WorldConformanceError<W>(e, new ConformanceResult.OldProblem(), world));
        }
        return Collections.emptyList();
    }

    default public List<ConformanceResult.WorldConformanceError<W>> checkSend(W world) {
        TestModule.CId a = new TestModule.CId(1);
        TestModule.CId b = new TestModule.CId(2);
        try {
            world.send((TestModule.CId)a, new TestModule.SendSetMember(10, b)).send(b, new TestModule.LocalSendSetMember(20, a));
        }
        catch (Exception e) {
            return Collections.singletonList(new ConformanceResult.WorldConformanceError<W>(e, new ConformanceResult.SendProblem(), world));
        }
        return Collections.emptyList();
    }

    default public List<ConformanceResult.WorldConformanceError<W>> checkDeterminism(W world) {
        TestModule.CId a = new TestModule.CId(1);
        TestModule.CId b = new TestModule.CId(2);
        TestModule.CId c = new TestModule.CId(3);
        TestModule.CId d = new TestModule.CId(4);
        try {
            for (int i = 0; i < 100; ++i) {
                world = world.init().send((TestModule.CId)a, new TestModule.CopyId()).send(b, new TestModule.LocalCopyId()).send(c, new TestModule.SetMember(20)).send(d, new TestModule.LocalSetMember(200)).world();
                if (world.obj((Id<TestModule.CObject>)a).value().member != 1) {
                    this.error("obj(a).value.member should be 1");
                }
                if (world.obj((Id<TestModule.CObject>)b).value().member != 2) {
                    this.error("obj(b).value.member should be 2");
                }
                if (world.obj((Id<TestModule.CObject>)c).value().member != 20) {
                    this.error("obj(c).value.member should be 20");
                }
                if (world.obj((Id<TestModule.CObject>)d).value().member == 200) continue;
                this.error("obj(d).value.member should be 200");
            }
        }
        catch (Exception e) {
            return Collections.singletonList(new ConformanceResult.WorldConformanceError<W>(e, new ConformanceResult.DeterminismProblem(), world));
        }
        return Collections.emptyList();
    }

    default public List<ConformanceResult.WorldConformanceError<W>> checkRollback(W world) {
        try {
            TestModule.CId b;
            TestModule.CId a;
            block7: {
                a = new TestModule.CId(1);
                b = new TestModule.CId(2);
                try {
                    world.send((TestModule.CId)a, new TestModule.ThrowPstException());
                }
                catch (Exception e) {
                    if (world.obj((Id<TestModule.CObject>)a).value().member == 0) break block7;
                    this.error("obj(a).value.member should be 0");
                }
            }
            try {
                world.send((TestModule.CId)b, new TestModule.ThrowPstException());
            }
            catch (Exception e) {
                if (world.obj((Id<TestModule.CObject>)a).value().member != 0) {
                    this.error("obj(b).value.member should be 0");
                }
            }
        }
        catch (Exception e) {
            return Collections.singletonList(new ConformanceResult.WorldConformanceError<W>(e, new ConformanceResult.RollbackProblem(), world));
        }
        return Collections.emptyList();
    }
}

