/*
 * Decompiled with CFR 0.152.
 */
package org.jmanikin.world;

import java.util.HashMap;
import java.util.function.Supplier;
import org.jmanikin.core.Apply;
import org.jmanikin.core.Effect;
import org.jmanikin.core.Environment;
import org.jmanikin.core.Id;
import org.jmanikin.core.Message;
import org.jmanikin.core.Msg;
import org.jmanikin.core.PostCondition;
import org.jmanikin.core.PreCondition;
import org.jmanikin.core.Value;
import org.jmanikin.core.World;
import org.jmanikin.test.WorldConformanceTest;

public class SimpleWorld
implements World<SimpleWorld> {
    private final HashMap<Object, Object> obj = new HashMap();
    private final HashMap<Object, Object> old = new HashMap();
    private static final boolean conformanceChecked = SimpleWorld.checkConformance();

    private static boolean checkConformance() {
        if (!conformanceChecked) {
            WorldConformanceTest.check(new SimpleWorld());
        }
        return true;
    }

    @Override
    public <O> Value<SimpleWorld, O> obj(Id<? extends O> id) {
        return new Value.ValueImpl<SimpleWorld, Object>(this, this.obj.getOrDefault(id, id.init()));
    }

    @Override
    public <O> Value<SimpleWorld, O> old(Id<? extends O> id) {
        return new Value.ValueImpl<SimpleWorld, Object>(this, this.old.getOrDefault(id, id.init()));
    }

    @Override
    public <I extends Id<O>, O, E> Value<SimpleWorld, E> send(I id, Message<I, O, E> message) {
        SimpleEnv env = new SimpleEnv(this, id);
        Msg<I, O, E> msg = message.msg(env);
        O oldObj = this.obj(id).value();
        if (!msg.pre().get().booleanValue()) {
            throw new RuntimeException("Pre-condition failed");
        }
        try {
            this.obj.put(id, msg.app().get());
            this.old.put(id, oldObj);
            E eff = msg.eff().get();
            this.old.put(id, oldObj);
            if (!msg.pst().get().booleanValue()) {
                throw new RuntimeException("Post-condition failed");
            }
            return new Value.ValueImpl<SimpleWorld, E>(env.world, eff);
        }
        catch (Exception e) {
            this.obj.put(id, oldObj);
            throw e;
        }
    }

    @Override
    public SimpleWorld init() {
        return new SimpleWorld();
    }

    private static class SimpleEnv<I extends Id<O>, O, E>
    implements Environment<I, O, E>,
    PreCondition<I, O, E>,
    Apply<I, O, E>,
    Effect<I, O, E>,
    PostCondition<I, O, E>,
    Msg<I, O, E> {
        private final SimpleWorld world;
        private final I self;
        private Supplier<Boolean> _pre;
        private Supplier<O> _app;
        private Supplier<E> _eff;
        private Supplier<Boolean> _pst;

        public SimpleEnv(SimpleWorld world, I self) {
            this.world = world;
            this.self = self;
        }

        @Override
        public I self() {
            return this.self;
        }

        @Override
        public <O2> O2 obj(Id<? extends O2> id) {
            return this.world.obj(id).value();
        }

        @Override
        public <O2> O2 old(Id<? extends O2> id) {
            return this.world.old(id).value();
        }

        @Override
        public <I2 extends Id<O2>, O2, R2> R2 send(I2 id, Message<I2, O2, R2> msg) {
            return this.world.send(id, msg).value();
        }

        @Override
        public Apply<I, O, E> pre(Supplier<Boolean> pre) {
            this._pre = pre;
            return this;
        }

        @Override
        public Effect<I, O, E> app(Supplier<O> app) {
            this._app = app;
            return this;
        }

        @Override
        public PostCondition<I, O, E> eff(Supplier<E> eff) {
            this._eff = eff;
            return this;
        }

        @Override
        public Msg<I, O, E> pst(Supplier<Boolean> pst) {
            this._pst = pst;
            return this;
        }

        @Override
        public Supplier<Boolean> pre() {
            return this._pre;
        }

        @Override
        public Supplier<O> app() {
            return this._app;
        }

        @Override
        public Supplier<E> eff() {
            return this._eff;
        }

        @Override
        public Supplier<Boolean> pst() {
            return this._pst;
        }
    }
}

