/*
 * Decompiled with CFR 0.152.
 */
package org.jmdware.ephemeral.locks;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EphemeralLocks {
    private final ConcurrentHashMap<Object, Context> keyToContext = new ConcurrentHashMap();

    public Handle lock(Object key) {
        Context ctx = this.keyToContext.compute(key, (k, v) -> {
            if (v == null) {
                v = new Context();
            }
            ((Context)v).count.incrementAndGet();
            return v;
        });
        ctx.lock.lock();
        AtomicBoolean closed = new AtomicBoolean();
        return () -> this.keyToContext.compute(key, (k, v) -> {
            if (closed.compareAndSet(false, true)) {
                ((Context)v).lock.unlock();
                return ((Context)v).count.decrementAndGet() == 0 ? null : v;
            }
            return v;
        });
    }

    public int size() {
        return this.keyToContext.size();
    }

    public static interface Handle
    extends AutoCloseable {
        @Override
        public void close();
    }

    private static class Context {
        private final Lock lock = new ReentrantLock();
        private final AtomicInteger count = new AtomicInteger();

        private Context() {
        }
    }
}

