/*
 * Decompiled with CFR 0.152.
 */
package org.jmmo.bresenham_line;

import org.jmmo.bresenham_line.LineProcessor2D;
import org.jmmo.bresenham_line.LineProcessor3D;
import org.jmmo.bresenham_line.PointHandler2D;
import org.jmmo.bresenham_line.PointHandler3D;

public class BresenhamLine
implements LineProcessor2D,
LineProcessor3D {
    protected static int sign(int a) {
        return a > 0 ? 1 : (a < 0 ? -1 : 0);
    }

    @Override
    public <T> T processLine2D(int x0, int y0, int x1, int y1, PointHandler2D<T> handler) {
        int d1;
        int d0;
        int py;
        int px;
        int abs_dy;
        int x = x0;
        int y = y0;
        T result = handler.handlePoint(x, y);
        if (result != null) {
            return result;
        }
        int dx = x1 - x0;
        int dy = y1 - y0;
        int sign_dx = BresenhamLine.sign(dx);
        int sign_dy = BresenhamLine.sign(dy);
        int abs_dx = Math.abs(dx);
        if (abs_dx > (abs_dy = Math.abs(dy))) {
            px = sign_dx;
            py = 0;
            d0 = abs_dx;
            d1 = abs_dy;
        } else {
            px = 0;
            py = sign_dy;
            d0 = abs_dy;
            d1 = abs_dx;
        }
        int delta = d0 / 2;
        for (int p = 0; p < d0; ++p) {
            if ((delta -= d1) < 0) {
                delta += d0;
                x += sign_dx;
                y += sign_dy;
            } else {
                x += px;
                y += py;
            }
            result = handler.handlePoint(x, y);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <T> T processLine3D(int x0, int y0, int z0, int x1, int y1, int z1, PointHandler3D<T> handler) {
        int delta1;
        int d2;
        int d1;
        int d0;
        int jz2;
        int jy2;
        int jx2;
        int jz1;
        int jy1;
        int jx1;
        int pz;
        int py;
        int px;
        int x = x0;
        int y = y0;
        int z = z0;
        T result = handler.handlePoint(x, y, z);
        if (result != null) {
            return result;
        }
        int dx = x1 - x0;
        int dy = y1 - y0;
        int dz = z1 - z0;
        int sign_dx = BresenhamLine.sign(dx);
        int sign_dy = BresenhamLine.sign(dy);
        int sign_dz = BresenhamLine.sign(dz);
        int abs_dx = Math.abs(dx);
        int abs_dy = Math.abs(dy);
        int abs_dz = Math.abs(dz);
        if (abs_dx > abs_dy && abs_dx > abs_dz) {
            px = sign_dx;
            py = 0;
            pz = 0;
            jx1 = 0;
            jy1 = sign_dy;
            jz1 = 0;
            jx2 = 0;
            jy2 = 0;
            jz2 = sign_dz;
            d0 = abs_dx;
            d1 = abs_dy;
            d2 = abs_dz;
        } else if (abs_dy > abs_dx && abs_dy > abs_dz) {
            px = 0;
            py = sign_dy;
            pz = 0;
            jx1 = sign_dx;
            jy1 = 0;
            jz1 = 0;
            jx2 = 0;
            jy2 = 0;
            jz2 = sign_dz;
            d0 = abs_dy;
            d1 = abs_dx;
            d2 = abs_dz;
        } else {
            px = 0;
            py = 0;
            pz = sign_dz;
            jx1 = sign_dx;
            jy1 = 0;
            jz1 = 0;
            jx2 = 0;
            jy2 = sign_dy;
            jz2 = 0;
            d0 = abs_dz;
            d1 = abs_dx;
            d2 = abs_dy;
        }
        int delta2 = delta1 = d0 / 2;
        for (int p = 0; p < d0; ++p) {
            delta2 -= d2;
            if ((delta1 -= d1) < 0) {
                delta1 += d0;
                x += jx1;
                y += jy1;
                z += jz1;
            }
            if (delta2 < 0) {
                delta2 += d0;
                x += jx2;
                y += jy2;
                z += jz2;
            }
            if ((result = handler.handlePoint(x += px, y += py, z += pz)) == null) continue;
            return result;
        }
        return null;
    }
}

