/*
 * Decompiled with CFR 0.152.
 */
package org.jmmo.util;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jmmo.util.impl.FilesIterator;

public class StreamUtil {
    private StreamUtil() {
    }

    public static <T> Stream<T> optional(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> nullable(T value) {
        return value == null ? Stream.empty() : Stream.of(value);
    }

    public static <T> Stream<T> fromIterator(Iterator<T> iterator) {
        return StreamUtil.fromIterator(iterator, 0);
    }

    public static <T> Stream<T> fromIterator(Iterator<T> iterator, int characteristics) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, characteristics), false);
    }

    public static <T> Stream<T> supply(final Supplier<T> supplier) {
        return StreamUtil.fromIterator(new Iterator<T>(){
            boolean prepared;
            T current;

            @Override
            public boolean hasNext() {
                if (!this.prepared) {
                    this.prepared = true;
                    this.current = supplier.get();
                }
                return this.current != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.prepared = false;
                    return this.current;
                }
                throw new NoSuchElementException();
            }
        }, 256);
    }

    public static Stream<MatchResult> matchResults(Matcher matcher) {
        return StreamUtil.supply(() -> matcher.find() ? matcher.toMatchResult() : null);
    }

    public static Stream<String> matchGroups(Matcher matcher) {
        return StreamUtil.matchGroups(matcher, 1);
    }

    public static Stream<String> matchGroups(Matcher matcher, int group) {
        return StreamUtil.supply(() -> matcher.find() ? matcher.group(group) : null);
    }

    public static Stream<Throwable> causes(final Throwable throwable) {
        return StreamUtil.supply(new Supplier<Throwable>(){
            Throwable next;
            {
                this.next = throwable;
            }

            @Override
            public Throwable get() {
                Throwable current = this.next;
                if (current != null) {
                    this.next = current.getCause();
                }
                return current;
            }
        });
    }

    public static Stream<Path> files(Path directory) {
        return StreamUtil.fromIterator(new FilesIterator(directory), 256).filter(path -> !Files.isDirectory(path, new LinkOption[0]));
    }

    public static Stream<Path> files(Path directory, String glob) {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher("glob:" + glob);
        return StreamUtil.fromIterator(new FilesIterator(directory, path -> Files.isDirectory(path, new LinkOption[0]) || matcher.matches(path.getFileName())), 256).filter(path -> !Files.isDirectory(path, new LinkOption[0]));
    }

    public static Stream<Path> files(Path directory, DirectoryStream.Filter<Path> filter) {
        return StreamUtil.fromIterator(new FilesIterator(directory, path -> Files.isDirectory(path, new LinkOption[0]) || filter.accept((Path)path)), 256).filter(path -> !Files.isDirectory(path, new LinkOption[0]));
    }

    public static Stream<Path> directories(Path directory) {
        return StreamUtil.fromIterator(new FilesIterator(directory, x$0 -> Files.isDirectory(x$0, new LinkOption[0])), 256);
    }

    public static Stream<Path> directories(Path directory, String glob) {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher("glob:" + glob);
        return StreamUtil.fromIterator(new FilesIterator(directory, path -> Files.isDirectory(path, new LinkOption[0]) && matcher.matches(path.getFileName())), 256);
    }

    public static Stream<Path> directories(Path directory, DirectoryStream.Filter<Path> filter) {
        return StreamUtil.fromIterator(new FilesIterator(directory, path -> Files.isDirectory(path, new LinkOption[0]) && filter.accept((Path)path)), 256);
    }

    public static Stream<Path> directoriesAndFiles(Path directory) {
        return StreamUtil.fromIterator(new FilesIterator(directory), 256);
    }

    public static Stream<Path> directoriesAndFiles(Path directory, String glob) {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher("glob:" + glob);
        return StreamUtil.fromIterator(new FilesIterator(directory, path -> matcher.matches(path.getFileName())), 256);
    }

    public static Stream<Path> directoriesAndFiles(Path directory, DirectoryStream.Filter<Path> filter) {
        return StreamUtil.fromIterator(new FilesIterator(directory, filter), 256);
    }

    public static <R, T extends Throwable> R sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    public static <R> R unchecked(Callable<R> callable) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            return StreamUtil.sneakyThrow(ex);
        }
    }

    public static void unchecked(ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            StreamUtil.sneakyThrow(ex);
        }
    }

    public static <T> T uncheckedNull(ThrowableRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            StreamUtil.sneakyThrow(ex);
        }
        return null;
    }

    public static <R> void uncheckedVoid(Callable<R> callable) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            StreamUtil.sneakyThrow(ex);
        }
    }

    public static <T> T resultNull(Runnable runnable) {
        runnable.run();
        return null;
    }

    public static <T> void resultVoid(Supplier<T> supplier) {
        supplier.get();
    }

    public static <T, R> Iterator<R> iteratorMap(final Iterator<T> iterator, final Function<? super T, ? extends R> mapper) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> iteratorFilter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        return new Iterator<T>(){
            T next;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.next = iterator.next();
                    if (!predicate.test(this.next)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.next;
            }

            @Override
            public void remove() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                iterator.remove();
            }
        };
    }

    public static <T, R> Iterator<R> iteratorFlatMap(final Iterator<T> iterator, final Function<? super T, ? extends Iterator<? extends R>> mapper) {
        return new Iterator<R>(){
            Iterator<? extends R> current = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                if (this.current.hasNext()) {
                    return true;
                }
                if (!iterator.hasNext()) {
                    return false;
                }
                this.current = (Iterator)mapper.apply(iterator.next());
                return this.hasNext();
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current.remove();
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Exception;
    }
}

