/*
 * Decompiled with CFR 0.152.
 */
package org.jmmo.util.impl;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilesIterator
implements Iterator<Path> {
    private final DirectoryStream.Filter<Path> filter;
    private DirectoryStream<Path> currentStream;
    private Iterator<Path> currentIterator;
    private boolean prepared;
    protected Path current;
    protected DirectoryItem lastDirectory;
    protected DirectoryItem directories;

    public FilesIterator(Path directory) {
        this(directory, path -> true);
    }

    public FilesIterator(Path directory, DirectoryStream.Filter<Path> filter) {
        this.filter = filter;
        this.initStream(new DirectoryItem(directory, null));
    }

    protected void initStream(DirectoryItem directoryItem) {
        try {
            this.currentStream = Files.newDirectoryStream(directoryItem.directory, this.filter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.currentIterator = this.currentStream.iterator();
        this.lastDirectory = directoryItem;
    }

    @Override
    public boolean hasNext() {
        while (!this.prepared) {
            this.current = null;
            if (this.currentIterator.hasNext()) {
                this.current = this.currentIterator.next();
                if (Files.isDirectory(this.current, new LinkOption[0])) {
                    this.directories = new DirectoryItem(this.current, this.directories);
                    continue;
                }
                this.prepared = true;
                continue;
            }
            if (!this.lastDirectory.processed) {
                this.lastDirectory.processed = true;
                this.closeStream();
            }
            this.pollNextDirectory();
        }
        return this.current != null;
    }

    protected void pollNextDirectory() {
        if (this.directories == null) {
            this.prepared = true;
        } else if (this.directories.processed) {
            this.current = this.directories.directory;
            this.prepared = true;
            this.directories = this.directories.next;
        } else {
            this.initStream(this.directories);
        }
    }

    protected void closeStream() {
        try {
            this.currentStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path next() {
        if (this.hasNext()) {
            this.prepared = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class DirectoryItem {
        final Path directory;
        final DirectoryItem next;
        boolean processed;

        DirectoryItem(Path directory, DirectoryItem next) {
            this.directory = directory;
            this.next = next;
        }
    }
}

