/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.imposters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Random;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.internal.SearchingClassLoader;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ByteBuddyClassImposteriser
implements Imposteriser {
    private static final String MOCK_TYPE_SUFFIX = "JMock";
    public static final Imposteriser INSTANCE = new ByteBuddyClassImposteriser();
    private final Random random = new Random();
    private final Objenesis objenesis = new ObjenesisStd();

    private ByteBuddyClassImposteriser() {
    }

    public boolean canImposterise(Class<?> type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers()) && (type.isInterface() || !this.toStringMethodIsFinal(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        if (!mockedType.isInterface() && this.toStringMethodIsFinal(mockedType)) {
            throw new IllegalArgumentException(mockedType.getName() + " has a final toString method");
        }
        try {
            this.setConstructorsAccessible(mockedType, true);
            T t = this.proxy(mockObject, mockedType, ancilliaryTypes);
            return t;
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private boolean toStringMethodIsFinal(Class<?> type) {
        try {
            Method toString = type.getMethod("toString", new Class[0]);
            return Modifier.isFinal(toString.getModifiers());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("not allowed to reflect on toString method", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("no public toString method found", e);
        }
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private <T> T proxy(final Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with(this.namingStrategy(mockedType)).subclass(mockedType).implement((Type[])ancilliaryTypes).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object receiver, Method method, Object[] args) throws Throwable {
                return mockObject.invoke(new Invocation(receiver, method, args));
            }
        }));
        try {
            ClassLoadingStrategy.Default strategy;
            if (ClassInjector.UsingLookup.isAvailable() && !this.protectedPackageNameSpaces(mockedType) && !this.defaultPackage(mockedType)) {
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
                Object privateLookup = privateLookupIn.invoke(null, mockedType, lookup);
                strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            return (T)this.objenesis.newInstance(builder.make().load(SearchingClassLoader.combineLoadersOf(mockedType, (Class[])ancilliaryTypes), (ClassLoadingStrategy)strategy).getLoaded());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Exception in code generation strategy available", e);
        }
    }

    private boolean defaultPackage(Class<?> mockedType) {
        return mockedType.getPackage().getName().isEmpty();
    }

    private NamingStrategy namingStrategy(Class<?> mockedType) {
        if (this.protectedPackageNameSpaces(mockedType)) {
            return new NamingStrategy.SuffixingRandom(MOCK_TYPE_SUFFIX);
        }
        return new NamingStrategy.AbstractBase(){

            protected String name(TypeDescription superClass) {
                String possiblePackageName = superClass.getPackage().getName();
                String validPackageName = possiblePackageName.isEmpty() ? "" : possiblePackageName + ".";
                return validPackageName + superClass.getSimpleName() + ByteBuddyClassImposteriser.MOCK_TYPE_SUFFIX + ByteBuddyClassImposteriser.this.random.nextInt(Integer.MAX_VALUE);
            }
        };
    }

    private boolean protectedPackageNameSpaces(Class<?> mockedType) {
        return mockedType.getName().startsWith("java.");
    }
}

