/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.imposters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.internal.SearchingClassLoader;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ByteBuddyClassImposteriser
implements Imposteriser {
    public static final Imposteriser INSTANCE = new ByteBuddyClassImposteriser();
    private static final String JMOCK_KEY = "jMock";
    private final Objenesis objenesis = new ObjenesisStd();
    private final Map<Set<Class<?>>, Class<?>> types = new ConcurrentHashMap();

    private ByteBuddyClassImposteriser() {
    }

    public boolean canImposterise(Class<?> type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers()) && (type.isInterface() || !this.toStringMethodIsFinal(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T imposterise(Invokable mockObject, Class<T> mockedType, Class<?> ... ancilliaryTypes) {
        if (!mockedType.isInterface() && this.toStringMethodIsFinal(mockedType)) {
            throw new IllegalArgumentException(mockedType.getName() + " has a final toString method");
        }
        try {
            this.setConstructorsAccessible(mockedType, true);
            T t = this.proxy(mockObject, mockedType, ancilliaryTypes);
            return t;
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private boolean toStringMethodIsFinal(Class<?> type) {
        try {
            Method toString = type.getMethod("toString", new Class[0]);
            return Modifier.isFinal(toString.getModifiers());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("not allowed to reflect on toString method", e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("no public toString method found", e);
        }
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private <T> T proxy(final Invokable mockObject, final Class<T> mockedType, final Class<?> ... ancilliaryTypes) {
        try {
            Set<Class<?>> mockTypeKey = this.mockTypeKey(mockedType, ancilliaryTypes);
            Class<?> proxyType = this.types.computeIfAbsent(mockTypeKey, new Function<Object, Class<?>>(){

                @Override
                public Class<?> apply(Object t) {
                    try {
                        return ByteBuddyClassImposteriser.this.proxyClass(mockObject, mockedType, ancilliaryTypes);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            InjectInvokable invokable = (InjectInvokable)this.objenesis.newInstance(proxyType);
            invokable.setJMock(mockObject);
            return (T)invokable;
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("Exception in code generation strategy available", e);
        }
    }

    private Class<?> proxyClass(Invokable mockObject, Class<?> mockedType, Class<?> ... ancilliaryTypes) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ClassLoadingStrategy.Default strategy;
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with((NamingStrategy)new NamingStrategy.SuffixingRandom(JMOCK_KEY, JMOCK_KEY.toLowerCase())).subclass(mockedType).implement((Type[])ancilliaryTypes).defineField(JMOCK_KEY, Invokable.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{InjectInvokable.class}).intercept((Implementation)FieldAccessor.ofField((String)JMOCK_KEY)).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(InjectInvokable.class))).intercept((Implementation)MethodDelegation.to(Interceptor.class));
        if (ClassInjector.UsingLookup.isAvailable() && !this.protectedPackageNameSpaces(mockedType) && !this.defaultPackage(mockedType)) {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
            Object privateLookup = privateLookupIn.invoke(null, mockedType, lookup);
            strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
        } else if (ClassInjector.UsingReflection.isAvailable()) {
            strategy = ClassLoadingStrategy.Default.INJECTION;
        } else {
            throw new IllegalStateException("No code generation strategy available");
        }
        Class proxyType = builder.make().load(SearchingClassLoader.combineLoadersOf(mockedType, (Class[])ancilliaryTypes), (ClassLoadingStrategy)strategy).getLoaded();
        return proxyType;
    }

    private Set<Class<?>> mockTypeKey(Class<?> mockedType, Class<?> ... ancilliaryTypes) {
        HashSet types = new HashSet();
        types.add(mockedType);
        for (Class<?> class1 : ancilliaryTypes) {
            types.add(class1);
        }
        return types;
    }

    private boolean defaultPackage(Class<?> mockedType) {
        return mockedType.getPackage().getName().isEmpty();
    }

    private boolean protectedPackageNameSpaces(Class<?> mockedType) {
        return mockedType.getName().startsWith("java.");
    }

    public static class Interceptor {
        @RuntimeType
        public static Object intercept(@This Object receiver, @Origin Method method, @FieldValue(value="jMock") Invokable invokable, @AllArguments Object[] args) throws Throwable {
            return invokable.invoke(new Invocation(receiver, method, args));
        }
    }

    public static interface InjectInvokable {
        public void setJMock(Invokable var1);

        public Invokable getJMock();
    }
}

