/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jmxtrans.agent.OutputWriter;

public class Query {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final ObjectName objectName;
    protected final String resultAlias;
    protected final String attribute;
    protected final String key;

    public Query(String objectName, String attribute, String resultAlias) {
        this(objectName, attribute, null, resultAlias);
    }

    public Query(String objectName, String attribute, String key, String resultAlias) {
        try {
            this.objectName = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid objectName '" + objectName + "'", e);
        }
        this.attribute = attribute;
        this.key = key;
        this.resultAlias = resultAlias;
    }

    public void collectAndExport(MBeanServer mbeanServer, OutputWriter outputWriter) {
        Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
        for (ObjectName on : objectNames) {
            try {
                Object attributeValue = mbeanServer.getAttribute(on, this.attribute);
                if (attributeValue instanceof CompositeData) {
                    CompositeData compositeData = (CompositeData)attributeValue;
                    if (this.key == null) {
                        this.logger.warning("Ignore compositeData without key specified for '" + on + "'#" + this.attribute + ": " + attributeValue);
                        continue;
                    }
                    outputWriter.write(this.resultAlias, compositeData.get(this.key));
                    continue;
                }
                if (this.key == null) {
                    outputWriter.write(this.resultAlias, attributeValue);
                    continue;
                }
                this.logger.warning("Ignore NON compositeData for specified key for '" + on + "'#" + this.attribute + "#" + this.key + ": " + attributeValue);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception collecting " + on + "#" + this.attribute + (this.key == null ? "" : "#" + this.key), e);
            }
        }
    }

    public String toString() {
        return "Query{objectName=" + this.objectName + ", resultAlias='" + this.resultAlias + '\'' + ", attribute='" + this.attribute + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

