/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.OutputWriterCircuitBreakerDecorator;
import org.jmxtrans.agent.OutputWritersChain;
import org.jmxtrans.agent.SimpleJmxExporter;
import org.jmxtrans.agent.util.PropertyPlaceholderResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimpleJmxExporterBuilder {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private PropertyPlaceholderResolver placeholderResolver = new PropertyPlaceholderResolver();

    public SimpleJmxExporter build(String configurationFilePath) throws Exception {
        Document document;
        if (configurationFilePath == null) {
            throw new NullPointerException("configurationFilePath cannot be null");
        }
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (configurationFilePath.toLowerCase().startsWith("classpath:")) {
            String classpathResourcePath = configurationFilePath.substring("classpath:".length());
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResourcePath);
            document = dBuilder.parse(in);
        } else if (configurationFilePath.toLowerCase().startsWith("file://") || configurationFilePath.toLowerCase().startsWith("http://") || configurationFilePath.toLowerCase().startsWith("https://")) {
            URL url = new URL(configurationFilePath);
            document = dBuilder.parse(url.openStream());
        } else {
            File xmlFile = new File(configurationFilePath);
            if (!xmlFile.exists()) {
                throw new IllegalArgumentException("Configuration file '" + xmlFile.getAbsolutePath() + "' not found");
            }
            document = dBuilder.parse(xmlFile);
        }
        Element rootElement = document.getDocumentElement();
        SimpleJmxExporter simpleJmxExporter = new SimpleJmxExporter();
        NodeList collectIntervalNodeList = rootElement.getElementsByTagName("collectIntervalInSeconds");
        switch (collectIntervalNodeList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Element collectIntervalElement = (Element)collectIntervalNodeList.item(0);
                String collectIntervalString = this.placeholderResolver.resolveString(collectIntervalElement.getTextContent());
                try {
                    simpleJmxExporter.withCollectInterval(Integer.parseInt(collectIntervalString), TimeUnit.SECONDS);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid <collectIntervalInSeconds> value '" + collectIntervalString + "', integer expected", e);
                }
            }
            default: {
                this.logger.warning("More than 1 <collectIntervalInSeconds> element found (" + collectIntervalNodeList.getLength() + "), use latest");
                Element lastCollectIntervalElement = (Element)collectIntervalNodeList.item(collectIntervalNodeList.getLength() - 1);
                String lastCollectIntervalString = this.placeholderResolver.resolveString(lastCollectIntervalElement.getTextContent());
                try {
                    simpleJmxExporter.withCollectInterval(Integer.parseInt(lastCollectIntervalString), TimeUnit.SECONDS);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid <collectIntervalInSeconds> value '" + lastCollectIntervalString + "', integer expected", e);
                }
            }
        }
        this.buildQueries(rootElement, simpleJmxExporter);
        this.buildOutputWriters(rootElement, simpleJmxExporter);
        return simpleJmxExporter;
    }

    private void buildQueries(Element rootElement, SimpleJmxExporter simpleJmxExporter) {
        NodeList queries = rootElement.getElementsByTagName("query");
        for (int i = 0; i < queries.getLength(); ++i) {
            Element queryElement = (Element)queries.item(i);
            String objectName = queryElement.getAttribute("objectName");
            String attribute = queryElement.getAttribute("attribute");
            String key = queryElement.hasAttribute("key") ? queryElement.getAttribute("key") : null;
            String resultAlias = queryElement.getAttribute("resultAlias");
            simpleJmxExporter.withQuery(objectName, attribute, key, resultAlias);
        }
    }

    private void buildOutputWriters(Element rootElement, SimpleJmxExporter simpleJmxExporter) {
        NodeList outputWriterNodeList = rootElement.getElementsByTagName("outputWriter");
        ArrayList<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
        for (int i = 0; i < outputWriterNodeList.getLength(); ++i) {
            Element outputWriterElement = (Element)outputWriterNodeList.item(i);
            String outputWriterClass = outputWriterElement.getAttribute("class");
            if (outputWriterClass.isEmpty()) {
                throw new IllegalArgumentException("<outputWriter> element must contain a 'class' attribute");
            }
            try {
                OutputWriter outputWriter = (OutputWriter)Class.forName(outputWriterClass).newInstance();
                HashMap<String, String> settings = new HashMap<String, String>();
                NodeList settingsNodeList = outputWriterElement.getElementsByTagName("*");
                for (int j = 0; j < settingsNodeList.getLength(); ++j) {
                    Element settingElement = (Element)settingsNodeList.item(j);
                    settings.put(settingElement.getNodeName(), this.placeholderResolver.resolveString(settingElement.getTextContent()));
                }
                outputWriter = new OutputWriterCircuitBreakerDecorator(outputWriter);
                outputWriter.postConstruct(settings);
                outputWriters.add(outputWriter);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception instantiating " + outputWriterClass, e);
            }
        }
        switch (outputWriters.size()) {
            case 0: {
                this.logger.warning("No outputwriter defined.");
                break;
            }
            case 1: {
                simpleJmxExporter.withOutputWriter((OutputWriter)outputWriters.get(0));
                break;
            }
            default: {
                simpleJmxExporter.withOutputWriter(new OutputWritersChain(outputWriters));
            }
        }
    }
}

