/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphitePlainTextTcpOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_PORT = "port";
    public static final String SETTING_HOST = "host";
    public static final String SETTING_NAME_PREFIX = "namePrefix";
    public static final int SETTING_PORT_DEFAULT_VALUE = 2003;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected String metricPathPrefix;
    protected InetSocketAddress graphiteServerSocketAddress;
    private Socket socket;
    private Writer writer;

    @Override
    public void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        this.graphiteServerSocketAddress = new InetSocketAddress(ConfigurationUtils.getString(settings, SETTING_HOST), ConfigurationUtils.getInt(settings, SETTING_PORT, 2003));
        this.metricPathPrefix = ConfigurationUtils.getString(settings, SETTING_NAME_PREFIX, null);
    }

    protected String buildMetricPathPrefix() {
        String hostname;
        if (this.metricPathPrefix != null) {
            return this.metricPathPrefix;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName().replaceAll("\\.", "_");
        }
        catch (UnknownHostException e) {
            hostname = "#unknown#";
        }
        this.metricPathPrefix = "servers." + hostname + ".";
        return this.metricPathPrefix;
    }

    @Override
    public void writeResult(String metricName, Object value) throws IOException {
        String msg = this.buildMetricPathPrefix() + metricName + " " + value + " " + TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        try {
            this.ensureGraphiteConnection();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Send '" + msg + "' to " + this.graphiteServerSocketAddress);
            }
            this.writer.write(msg + "\n");
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception sending '" + msg + "' to " + this.graphiteServerSocketAddress, e);
            this.releaseGraphiteConnection();
            throw e;
        }
    }

    private void releaseGraphiteConnection() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception closing writer for socket " + this.socket, e);
            }
            this.writer = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception closing socket " + this.socket, e);
            }
            this.socket = null;
        }
    }

    private void ensureGraphiteConnection() throws IOException {
        boolean socketIsValid;
        try {
            socketIsValid = this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        }
        catch (Exception e) {
            socketIsValid = false;
        }
        if (!socketIsValid) {
            this.writer = null;
            try {
                this.socket = new Socket(this.graphiteServerSocketAddress.getAddress(), this.graphiteServerSocketAddress.getPort());
            }
            catch (IOException e) {
                ConnectException ce = new ConnectException("Exception connecting to " + this.graphiteServerSocketAddress);
                ce.initCause(e);
                throw ce;
            }
        }
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.socket.getOutputStream(), UTF_8);
        }
    }

    @Override
    public void postCollect() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
    }

    public String toString() {
        return "GraphitePlainTextTcpOutputWriter{, graphiteServerSocketAddress=" + this.graphiteServerSocketAddress + ", metricPathPrefix='" + this.metricPathPrefix + '\'' + '}';
    }
}

