/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOverwriterOutputWriter
extends AbstractOutputWriter {
    public static final String SETTING_FILE_NAME = "fileName";
    public static final String SETTING_FILE_NAME_DEFAULT_VALUE = "jmxtrans-agent.data";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected Writer temporaryFileWriter;
    protected File temporaryFile;
    protected File file = new File("jmxtrans-agent.data");

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        this.file = new File(ConfigurationUtils.getString(settings, SETTING_FILE_NAME, SETTING_FILE_NAME_DEFAULT_VALUE));
        this.logger.info("FileOverwriterOutputWriter configured with file " + this.file.getAbsolutePath());
    }

    protected Writer getTemporaryFileWriter() throws IOException {
        if (this.temporaryFile == null) {
            this.temporaryFile = File.createTempFile("jmxtrans-agent-", ".data");
            this.temporaryFile.deleteOnExit();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Created temporary file " + this.temporaryFile.getAbsolutePath());
            }
            this.temporaryFileWriter = null;
        }
        if (this.temporaryFileWriter == null) {
            this.temporaryFileWriter = new BufferedWriter(new FileWriter(this.temporaryFile, false));
        }
        return this.temporaryFileWriter;
    }

    @Override
    public synchronized void writeQueryResult(String metricName, Object value) throws IOException {
        this.writeResult(metricName, value);
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeResult(invocationName, value);
    }

    @Override
    protected void writeResult(String name, Object value) throws IOException {
        try {
            this.getTemporaryFileWriter().write(name + " " + value + "\n");
        }
        catch (IOException e) {
            this.releaseTemporaryWriter();
            throw e;
        }
    }

    protected void releaseTemporaryWriter() {
        try {
            IoUtils.closeQuietly(this.getTemporaryFileWriter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.temporaryFile != null) {
            this.temporaryFile.delete();
        }
        this.temporaryFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void postCollect() throws IOException {
        try {
            this.getTemporaryFileWriter().close();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Overwrite " + this.file.getAbsolutePath() + " by " + this.temporaryFile.getAbsolutePath());
            }
            IoUtils.replaceFile(this.temporaryFile, this.file);
        }
        finally {
            this.temporaryFileWriter = null;
        }
    }

    public static class IoUtils {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doCopySmallFile(File source, File destination) throws IOException {
            if (destination.exists() && destination.isDirectory()) {
                throw new IOException("Can not copy file, destination is a directory: " + destination.getAbsolutePath());
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            FileChannel input = null;
            FileChannel output = null;
            try {
                fis = new FileInputStream(source);
                fos = new FileOutputStream(destination, false);
                input = fis.getChannel();
                output = fos.getChannel();
                output.transferFrom(input, 0L, input.size());
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(output);
                IoUtils.closeQuietly(input);
                IoUtils.closeQuietly(fis);
                IoUtils.closeQuietly(fos);
                throw throwable;
            }
            IoUtils.closeQuietly(output);
            IoUtils.closeQuietly(input);
            IoUtils.closeQuietly(fis);
            IoUtils.closeQuietly(fos);
            if (destination.length() != source.length()) {
                throw new IOException("Failed to copy content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + ")");
            }
        }

        public static void closeQuietly(Closeable closeable) {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void closeQuietly(Writer writer) {
            if (writer == null) {
                return;
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void closeQuietly(InputStream inputStream) {
            if (inputStream == null) {
                return;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void replaceFile(File source, File destination) throws IOException {
            boolean deleted;
            boolean destinationExists = destination.exists() ? !(deleted = destination.delete()) : false;
            if (destinationExists) {
                IoUtils.doCopySmallFile(source, destination);
            } else {
                boolean renamed = source.renameTo(destination);
                if (!renamed) {
                    IoUtils.doCopySmallFile(source, destination);
                }
            }
        }
    }
}

