/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jmxtrans.agent.OutputWriter;

public class Invocation {
    protected final ObjectName objectName;
    protected final String operationName;
    protected final String resultAlias;
    protected final Object[] params;
    protected final String[] signature;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Invocation(String objectName, String operationName, Object[] params, String[] signature, String resultAlias) {
        try {
            this.objectName = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid objectName '" + objectName + "'", e);
        }
        this.operationName = operationName;
        this.params = params;
        this.signature = signature;
        this.resultAlias = resultAlias;
    }

    public void invoke(MBeanServer mbeanServer, OutputWriter outputWriter) {
        Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
        for (ObjectName on : objectNames) {
            try {
                Object result = mbeanServer.invoke(on, this.operationName, this.params, this.signature);
                outputWriter.writeInvocationResult(this.resultAlias, result);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception invoking " + on + "#" + this.operationName + "(" + Arrays.toString(this.params) + ")", e);
            }
        }
    }

    public String toString() {
        return "Invocation{objectName=" + this.objectName + ", operationName='" + this.operationName + '\'' + ", resultAlias='" + this.resultAlias + '\'' + ", params=" + Arrays.toString(this.params) + ", signature=" + Arrays.toString(this.signature) + '}';
    }
}

