/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.collect.Iterables2;

public class Query {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Nonnull
    protected final ObjectName objectName;
    @Nonnull
    protected final String resultAlias;
    @Nonnull
    protected final String attribute;
    @Nullable
    protected final String key;
    @Nullable
    protected final Integer position;
    @Nullable
    private String type;

    public Query(@Nonnull String objectName, @Nonnull String attribute) {
        this(objectName, attribute, null, null, attribute);
    }

    public Query(@Nonnull String objectName, @Nonnull String attribute, int position) {
        this(objectName, attribute, null, position, attribute);
    }

    public Query(@Nonnull String objectName, @Nonnull String attribute, @Nonnull String resultAlias) {
        this(objectName, attribute, null, null, resultAlias);
    }

    public Query(@Nonnull String objectName, @Nonnull String attribute, @Nullable String key, @Nullable Integer position, @Nonnull String resultAlias) {
        try {
            this.objectName = new ObjectName(Preconditions2.checkNotNull(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid objectName '" + objectName + "'", e);
        }
        this.attribute = Preconditions2.checkNotNull(attribute);
        this.key = key;
        this.resultAlias = Preconditions2.checkNotNull(resultAlias);
        this.position = position;
    }

    public void collectAndExport(@Nonnull MBeanServer mbeanServer, @Nonnull OutputWriter outputWriter) {
        Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
        for (ObjectName on : objectNames) {
            try {
                ArrayList<Object> value;
                ArrayList<Object> attributeValue = mbeanServer.getAttribute(on, this.attribute);
                if (attributeValue instanceof CompositeData) {
                    CompositeData compositeData = (CompositeData)((Object)attributeValue);
                    if (this.key == null) {
                        this.logger.warning("Ignore compositeData without key specified for '" + on + "'#" + this.attribute + ": " + attributeValue);
                        continue;
                    }
                    value = compositeData.get(this.key);
                } else if (this.key == null) {
                    value = attributeValue;
                } else {
                    this.logger.warning("Ignore NON compositeData for specified key for '" + on + "'#" + this.attribute + "#" + this.key + ": " + attributeValue);
                    continue;
                }
                if (value != null && value.getClass().isArray()) {
                    ArrayList<Object> valueAsList = new ArrayList<Object>();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        valueAsList.add(Array.get(value, i));
                    }
                    value = valueAsList;
                }
                if (value instanceof Iterable) {
                    Iterable iterable = value;
                    if (this.position == null) {
                        int idx = 0;
                        for (Object entry : iterable) {
                            outputWriter.writeQueryResult(this.resultAlias + "_" + idx++, this.type, entry);
                        }
                        continue;
                    }
                    value = Iterables2.get((Iterable)value, this.position);
                    outputWriter.writeQueryResult(this.resultAlias, this.type, value);
                    continue;
                }
                outputWriter.writeQueryResult(this.resultAlias, this.type, value);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception collecting " + on + "#" + this.attribute + (this.key == null ? "" : "#" + this.key), e);
            }
        }
    }

    public String toString() {
        return "Query{objectName=" + this.objectName + ", resultAlias='" + this.resultAlias + '\'' + ", attribute='" + this.attribute + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

