/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import org.jmxtrans.agent.DevNullOutputWriter;
import org.jmxtrans.agent.Invocation;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.Query;

public class JmxTransExporter {
    protected List<Query> queries = new ArrayList<Query>();
    protected List<Invocation> invocations = new ArrayList<Invocation>();
    protected OutputWriter outputWriter = new DevNullOutputWriter();
    protected int collectInterval = 10;
    protected TimeUnit collectIntervalTimeUnit = TimeUnit.SECONDS;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ThreadFactory threadFactory = new ThreadFactory(){
        final AtomicInteger counter = new AtomicInteger();

        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("jmxtrans-agent-" + this.counter.incrementAndGet());
            return thread;
        }
    };
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, this.threadFactory);
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private ScheduledFuture scheduledFuture;

    public JmxTransExporter withQuery(@Nonnull String objectName, @Nonnull String attribute, @Nullable String resultAlias) {
        return this.withQuery(objectName, attribute, null, null, null, resultAlias);
    }

    public JmxTransExporter withQuery(@Nonnull String objectName, @Nonnull String attribute, @Nullable String key, @Nullable Integer position, @Nullable String type, @Nullable String resultAlias) {
        this.queries.add(new Query(objectName, attribute, key, position, type, resultAlias));
        return this;
    }

    public JmxTransExporter withInvocation(@Nonnull String objectName, @Nonnull String operation, @Nullable String resultAlias) {
        this.invocations.add(new Invocation(objectName, operation, new Object[0], new String[0], resultAlias));
        return this;
    }

    public JmxTransExporter withOutputWriter(OutputWriter outputWriter) {
        this.outputWriter = outputWriter;
        return this;
    }

    public JmxTransExporter withCollectInterval(int collectInterval, @Nonnull TimeUnit collectIntervalTimeUnit) {
        this.collectInterval = collectInterval;
        this.collectIntervalTimeUnit = collectIntervalTimeUnit;
        return this;
    }

    public void start() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.fine("starting " + this.toString() + " ...");
        } else {
            this.logger.fine("starting " + this.getClass().getName() + " ...");
        }
        if (this.scheduledFuture != null) {
            throw new IllegalArgumentException("Exporter is already started");
        }
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                JmxTransExporter.this.collectAndExport();
            }
        }, this.collectInterval / 2, this.collectInterval, this.collectIntervalTimeUnit);
        this.logger.fine(this.getClass().getName() + " started");
    }

    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.scheduledExecutorService.shutdown();
        this.collectAndExport();
        try {
            this.scheduledExecutorService.awaitTermination(this.collectInterval, this.collectIntervalTimeUnit);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        this.logger.info(this.getClass().getName() + " stopped.");
    }

    protected void collectAndExport() {
        try {
            this.outputWriter.preCollect();
            for (Invocation invocation : this.invocations) {
                try {
                    invocation.invoke(this.mbeanServer, this.outputWriter);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Ignore exception invoking " + invocation, e);
                }
            }
            for (Query query : this.queries) {
                try {
                    query.collectAndExport(this.mbeanServer, this.outputWriter);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Ignore exception collecting metrics for " + query, e);
                }
            }
            this.outputWriter.postCollect();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Ignore exception flushing metrics ", e);
        }
    }

    public String toString() {
        return "JmxTransExporter{queries=" + this.queries + ", invocations=" + this.invocations + ", outputWriter=" + this.outputWriter + ", collectInterval=" + this.collectInterval + " " + (Object)((Object)this.collectIntervalTimeUnit) + '}';
    }
}

