/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import org.jmxtrans.agent.Query;
import org.jmxtrans.agent.util.StringUtils2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultNameStrategy {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Nonnull
    private Map<String, Callable<String>> expressionEvaluators = new HashMap<String, Callable<String>>();

    public ResultNameStrategy() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            String reversedHostName = StringUtils2.reverseTokens(hostName, ".");
            String canonicalHostName = localHost.getCanonicalHostName();
            String reversedCanonicalHostName = StringUtils2.reverseTokens(canonicalHostName, ".");
            String hostAddress = localHost.getHostAddress();
            this.registerExpressionEvaluator("hostname", hostName);
            this.registerExpressionEvaluator("reversed_hostname", reversedHostName);
            this.registerExpressionEvaluator("escaped_hostname", hostName.replaceAll("\\.", "_"));
            this.registerExpressionEvaluator("canonical_hostname", canonicalHostName);
            this.registerExpressionEvaluator("reversed_canonical_hostname", reversedCanonicalHostName);
            this.registerExpressionEvaluator("escaped_canonical_hostname", canonicalHostName.replaceAll("\\.", "_"));
            this.registerExpressionEvaluator("hostaddress", hostAddress);
            this.registerExpressionEvaluator("escaped_hostaddress", hostAddress.replaceAll("\\.", "_"));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception resolving localhost, expressions like #hostname#, #canonical_hostname# or #hostaddress# will not be available", e);
        }
    }

    @Nonnull
    public String getResultName(@Nonnull Query query, @Nonnull ObjectName objectName) {
        return this.getResultName(query, objectName, null);
    }

    @Nonnull
    public String getResultName(@Nonnull Query query, @Nonnull ObjectName objectName, @Nullable String key) {
        String result = query.getResultAlias() == null ? (key == null ? this.escapeObjectName(objectName) + "." + query.getAttribute() : this.escapeObjectName(objectName) + "." + query.getAttribute() + "." + key) : this.resolveExpression(query.getResultAlias(), objectName);
        return result;
    }

    @Nonnull
    public String resolveExpression(@Nonnull String expression) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            char c = expression.charAt(position);
            if (c == '#') {
                String value;
                int beginningSeparatorPosition = position;
                int endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                String key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + key + "'", e);
                    }
                }
                this.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + "): " + result);
        }
        return result.toString();
    }

    protected String resolveExpression(@Nonnull String expression, @Nonnull ObjectName exactObjectName) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            String key;
            int endingSeparatorPosition;
            int beginningSeparatorPosition;
            char c = expression.charAt(position);
            if (c == '%') {
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(37, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '%' after beginning '%' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                String value = exactObjectName.getKeyProperty(key);
                if (value == null) {
                    value = "null";
                }
                this.appendEscapedNonAlphaNumericChars(value, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            if (c == '#') {
                String value;
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + key + "'", e);
                    }
                }
                this.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + ", " + exactObjectName + "): " + result);
        }
        return result.toString();
    }

    protected String escapeObjectName(@Nonnull ObjectName objectName) {
        StringBuilder result = new StringBuilder();
        this.appendEscapedNonAlphaNumericChars(objectName.getDomain(), result);
        result.append('.');
        ArrayList<String> keys = Collections.list(objectName.getKeyPropertyList().keys());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.appendEscapedNonAlphaNumericChars(key, result);
            result.append("__");
            this.appendEscapedNonAlphaNumericChars(objectName.getKeyProperty(key), result);
            if (!it.hasNext()) continue;
            result.append('.');
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "escapeObjectName(" + objectName + "): " + result);
        }
        return result.toString();
    }

    private void appendEscapedNonAlphaNumericChars(String str, StringBuilder result) {
        this.appendEscapedNonAlphaNumericChars(str, true, result);
    }

    private void appendEscapedNonAlphaNumericChars(@Nonnull String str, boolean escapeDot, @Nonnull StringBuilder result) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') {
                result.append(ch);
                continue;
            }
            if (ch == '.') {
                result.append(escapeDot ? (char)'_' : ch);
                continue;
            }
            if (ch == '\"' && (i == 0 || i == chars.length - 1)) continue;
            result.append('_');
        }
    }

    public void registerExpressionEvaluator(String expression, Callable<String> evaluator) {
        this.expressionEvaluators.put(expression, evaluator);
    }

    public void registerExpressionEvaluator(String expression, String value) {
        this.expressionEvaluators.put(expression, new StaticEvaluator(value));
    }

    @Nonnull
    public Map<String, Callable<String>> getExpressionEvaluators() {
        return this.expressionEvaluators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticEvaluator
    implements Callable<String> {
        final String value;

        public StaticEvaluator(String value) {
            this.value = value;
        }

        @Override
        public String call() throws Exception {
            return this.value;
        }

        public String toString() {
            return "StaticStringCallable{value='" + this.value + '\'' + '}';
        }
    }
}

