/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputWriterCircuitBreakerDecorator
implements OutputWriter {
    public static final String SETTING_ENABLED = "enabled";
    protected final Logger logger;
    protected final OutputWriter delegate;
    private boolean enabled = true;
    private int maxFailures = 5;
    private long disableDurationInMillis = 60000L;
    private AtomicInteger failuresCounter = new AtomicInteger();
    private long disabledUntil = 0L;

    public OutputWriterCircuitBreakerDecorator(OutputWriter delegate) {
        this.delegate = delegate;
        this.logger = Logger.getLogger(delegate.getClass().getName() + "CircuitBreaker");
    }

    @Override
    public void postConstruct(Map<String, String> settings) {
        this.enabled = ConfigurationUtils.getBoolean(settings, SETTING_ENABLED, true);
        this.delegate.postConstruct(settings);
    }

    @Override
    public void preDestroy() {
        this.delegate.preDestroy();
    }

    @Override
    public void preCollect() throws IOException {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.delegate.preCollect();
            this.incrementOutputWriterSuccess();
        }
        catch (RuntimeException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
        catch (IOException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
    }

    @Override
    public void writeQueryResult(@Nonnull String metricName, @Nullable String metricType, @Nullable Object value) throws IOException {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.delegate.writeQueryResult(metricName, metricType, value);
            this.incrementOutputWriterSuccess();
        }
        catch (RuntimeException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
        catch (IOException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.delegate.writeInvocationResult(invocationName, value);
            this.incrementOutputWriterSuccess();
        }
        catch (RuntimeException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
        catch (IOException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
    }

    @Override
    public void postCollect() throws IOException {
        if (this.isDisabled()) {
            return;
        }
        try {
            this.delegate.postCollect();
            this.incrementOutputWriterSuccess();
        }
        catch (RuntimeException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
        catch (IOException e) {
            this.incrementOutputWriterFailures();
            throw e;
        }
    }

    public boolean isDisabled() {
        if (!this.enabled) {
            this.logger.finer("OutputWriter is globally disabled");
            return true;
        }
        if (this.disabledUntil == 0L) {
            this.logger.finer("OutputWriter is not temporarily disabled");
            return false;
        }
        if (this.disabledUntil < System.currentTimeMillis()) {
            this.logger.fine("re-enable OutputWriter");
            this.disabledUntil = 0L;
            return false;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("OutputWriter is disabled until " + new Timestamp(this.disabledUntil));
        }
        return true;
    }

    public void incrementOutputWriterFailures() {
        int failuresCount = this.failuresCounter.incrementAndGet();
        if (failuresCount >= this.maxFailures) {
            this.disabledUntil = System.currentTimeMillis() + this.disableDurationInMillis;
            this.failuresCounter.set(0);
            this.logger.warning("Too many exceptions, disable writer until " + new Timestamp(this.disabledUntil));
        }
    }

    public void incrementOutputWriterSuccess() {
        if (this.failuresCounter.get() > 0) {
            this.logger.fine("Reset failures counter to 0");
            this.failuresCounter.set(0);
        }
    }
}

