/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.util.Preconditions2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils2 {
    private StringUtils2() {
    }

    public static List<String> delimitedStringToList(@Nullable String delimitedString) {
        if (delimitedString == null) {
            return null;
        }
        String[] splits = delimitedString.split("[,;\\n]");
        ArrayList<String> result = new ArrayList<String>();
        for (String split : splits) {
            if ((split = split.trim()).isEmpty()) continue;
            result.add(split);
        }
        return result;
    }

    public static String join(@Nullable List<String> tokens, @Nonnull String delimiter) {
        if (tokens == null) {
            return null;
        }
        Preconditions2.checkNotNull(delimiter, "given delimiter can not be null");
        Iterator<String> it = tokens.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String token = it.next();
            sb.append(token);
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String reverseTokens(@Nullable String str, @Nonnull String delimiter) {
        if (str == null) {
            return null;
        }
        Preconditions2.checkNotNull(delimiter, "given delimiter can not be null");
        StringTokenizer st = new StringTokenizer(str, delimiter);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        Collections.reverse(tokens);
        return StringUtils2.join(tokens, delimiter);
    }

    public static void appendEscapedNonAlphaNumericChars(@Nonnull String str, boolean escapeDot, @Nonnull StringBuilder result) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') {
                result.append(ch);
                continue;
            }
            if (ch == '.') {
                result.append(escapeDot ? (char)'_' : ch);
                continue;
            }
            if (ch == '\"' && (i == 0 || i == chars.length - 1)) continue;
            result.append('_');
        }
    }

    public static void appendEscapedNonAlphaNumericChars(@Nonnull String str, @Nonnull StringBuilder result) {
        StringUtils2.appendEscapedNonAlphaNumericChars(str, true, result);
    }
}

