/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.management.ObjectName;
import org.jmxtrans.agent.ExpressionLanguageEngine;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageEngineImpl
implements ExpressionLanguageEngine {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    @Nonnull
    private Map<String, Callable<String>> expressionEvaluators = new HashMap<String, Callable<String>>();

    public ExpressionLanguageEngineImpl() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            String reversedHostName = StringUtils2.reverseTokens(hostName, ".");
            String canonicalHostName = localHost.getCanonicalHostName();
            String reversedCanonicalHostName = StringUtils2.reverseTokens(canonicalHostName, ".");
            String hostAddress = localHost.getHostAddress();
            this.registerExpressionEvaluator("hostname", hostName);
            this.registerExpressionEvaluator("reversed_hostname", reversedHostName);
            this.registerExpressionEvaluator("escaped_hostname", hostName.replaceAll("\\.", "_"));
            this.registerExpressionEvaluator("canonical_hostname", canonicalHostName);
            this.registerExpressionEvaluator("reversed_canonical_hostname", reversedCanonicalHostName);
            this.registerExpressionEvaluator("escaped_canonical_hostname", canonicalHostName.replaceAll("\\.", "_"));
            this.registerExpressionEvaluator("hostaddress", hostAddress);
            this.registerExpressionEvaluator("escaped_hostaddress", hostAddress.replaceAll("\\.", "_"));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception resolving localhost, expressions like #hostname#, #canonical_hostname# or #hostaddress# will not be available", e);
        }
    }

    @Override
    @Nonnull
    public String resolveExpression(@Nonnull String expression) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            char c = expression.charAt(position);
            if (c == '#') {
                String value;
                int beginningSeparatorPosition = position;
                int endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                String key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + key + "'", e);
                    }
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + "): " + result);
        }
        return result.toString();
    }

    @Override
    @Nonnull
    public String resolveExpression(@Nonnull String expression, @Nonnull ObjectName exactObjectName) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            String key;
            int endingSeparatorPosition;
            int beginningSeparatorPosition;
            char c = expression.charAt(position);
            if (c == '%') {
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(37, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '%' after beginning '%' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                String value = exactObjectName.getKeyProperty(key);
                if (value == null) {
                    value = "null";
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            if (c == '#') {
                String value;
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.log(Level.WARNING, "Error evaluating expression '" + key + "'", e);
                    }
                }
                StringUtils2.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "resolveExpression(" + expression + ", " + exactObjectName + "): " + result);
        }
        return result.toString();
    }

    public void registerExpressionEvaluator(String expression, Callable<String> evaluator) {
        this.expressionEvaluators.put(expression, evaluator);
    }

    public void registerExpressionEvaluator(String expression, String value) {
        this.expressionEvaluators.put(expression, new StaticEvaluator(value));
    }

    @Nonnull
    public Map<String, Callable<String>> getExpressionEvaluators() {
        return this.expressionEvaluators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticEvaluator
    implements Callable<String> {
        final String value;

        public StaticEvaluator(String value) {
            this.value = value;
        }

        @Override
        public String call() throws Exception {
            return this.value;
        }

        public String toString() {
            return "StaticStringCallable{value='" + this.value + '\'' + '}';
        }
    }
}

