/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.lang.instrument.Instrumentation;
import java.util.logging.Level;
import org.jmxtrans.agent.JmxTransExporter;
import org.jmxtrans.agent.JmxTransExporterBuilder;
import org.jmxtrans.agent.util.logging.Logger;

public class JmxTransAgent {
    private static Logger logger = Logger.getLogger(JmxTransAgent.class.getName());

    public static void premain(String configFile, Instrumentation inst) {
        if (configFile == null || configFile.isEmpty()) {
            String msg = "JmxTransExporter configurationFile must be defined";
            logger.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
        try {
            JmxTransExporter jmxTransExporter = new JmxTransExporterBuilder().build(configFile);
            jmxTransExporter.start();
            logger.info("JmxTransAgent started with configuration '" + configFile + "'");
        }
        catch (Exception e) {
            String msg = "Exception loading JmxTransExporter from '" + configFile + "'";
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }
}

