/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jmxtrans.agent.JmxTransExporter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.OutputWriterCircuitBreakerDecorator;
import org.jmxtrans.agent.OutputWritersChain;
import org.jmxtrans.agent.ResultNameStrategy;
import org.jmxtrans.agent.ResultNameStrategyImpl;
import org.jmxtrans.agent.util.PropertyPlaceholderResolver;
import org.jmxtrans.agent.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JmxTransExporterBuilder {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private PropertyPlaceholderResolver placeholderResolver = new PropertyPlaceholderResolver();

    public JmxTransExporter build(String configurationFilePath) throws Exception {
        Document document;
        if (configurationFilePath == null) {
            throw new NullPointerException("configurationFilePath cannot be null");
        }
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (configurationFilePath.toLowerCase().startsWith("classpath:")) {
            String classpathResourcePath = configurationFilePath.substring("classpath:".length());
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResourcePath);
            document = dBuilder.parse(in);
        } else if (configurationFilePath.toLowerCase().startsWith("file://") || configurationFilePath.toLowerCase().startsWith("http://") || configurationFilePath.toLowerCase().startsWith("https://")) {
            URL url = new URL(configurationFilePath);
            document = dBuilder.parse(url.openStream());
        } else {
            File xmlFile = new File(configurationFilePath);
            if (!xmlFile.exists()) {
                throw new IllegalArgumentException("Configuration file '" + xmlFile.getAbsolutePath() + "' not found");
            }
            document = dBuilder.parse(xmlFile);
        }
        Element rootElement = document.getDocumentElement();
        JmxTransExporter jmxTransExporter = new JmxTransExporter();
        NodeList collectIntervalNodeList = rootElement.getElementsByTagName("collectIntervalInSeconds");
        switch (collectIntervalNodeList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Element collectIntervalElement = (Element)collectIntervalNodeList.item(0);
                String collectIntervalString = this.placeholderResolver.resolveString(collectIntervalElement.getTextContent());
                try {
                    jmxTransExporter.withCollectInterval(Integer.parseInt(collectIntervalString), TimeUnit.SECONDS);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid <collectIntervalInSeconds> value '" + collectIntervalString + "', integer expected", e);
                }
            }
            default: {
                this.logger.warning("More than 1 <collectIntervalInSeconds> element found (" + collectIntervalNodeList.getLength() + "), use latest");
                Element lastCollectIntervalElement = (Element)collectIntervalNodeList.item(collectIntervalNodeList.getLength() - 1);
                String lastCollectIntervalString = this.placeholderResolver.resolveString(lastCollectIntervalElement.getTextContent());
                try {
                    jmxTransExporter.withCollectInterval(Integer.parseInt(lastCollectIntervalString), TimeUnit.SECONDS);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid <collectIntervalInSeconds> value '" + lastCollectIntervalString + "', integer expected", e);
                }
            }
        }
        this.buildResultNameStrategy(rootElement, jmxTransExporter);
        this.buildInvocations(rootElement, jmxTransExporter);
        this.buildQueries(rootElement, jmxTransExporter);
        this.buildOutputWriters(rootElement, jmxTransExporter);
        return jmxTransExporter;
    }

    private void buildQueries(Element rootElement, JmxTransExporter jmxTransExporter) {
        NodeList queries = rootElement.getElementsByTagName("query");
        for (int i = 0; i < queries.getLength(); ++i) {
            Integer position;
            Element queryElement = (Element)queries.item(i);
            String objectName = queryElement.getAttribute("objectName");
            String attribute = queryElement.getAttribute("attribute");
            String key = queryElement.hasAttribute("key") ? queryElement.getAttribute("key") : null;
            String resultAlias = queryElement.getAttribute("resultAlias");
            String type = queryElement.getAttribute("type");
            try {
                position = queryElement.hasAttribute("position") ? Integer.valueOf(Integer.parseInt(queryElement.getAttribute("position"))) : null;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid 'position' attribute for query objectName=" + objectName + ", attribute=" + attribute + ", resultAlias=" + resultAlias);
            }
            jmxTransExporter.withQuery(objectName, attribute, key, position, type, resultAlias);
        }
    }

    private void buildInvocations(Element rootElement, JmxTransExporter jmxTransExporter) {
        NodeList invocations = rootElement.getElementsByTagName("invocation");
        for (int i = 0; i < invocations.getLength(); ++i) {
            Element invocationElement = (Element)invocations.item(i);
            String objectName = invocationElement.getAttribute("objectName");
            String operation = invocationElement.getAttribute("operation");
            String resultAlias = invocationElement.getAttribute("resultAlias");
            jmxTransExporter.withInvocation(objectName, operation, resultAlias);
        }
    }

    private void buildResultNameStrategy(Element rootElement, JmxTransExporter jmxTransExporter) {
        ResultNameStrategy resultNameStrategy;
        NodeList resultNameStrategyNodeList = rootElement.getElementsByTagName("resultNameStrategy");
        switch (resultNameStrategyNodeList.getLength()) {
            case 0: {
                resultNameStrategy = new ResultNameStrategyImpl();
                break;
            }
            case 1: {
                Element resultNameStrategyElement = (Element)resultNameStrategyNodeList.item(0);
                String outputWriterClass = resultNameStrategyElement.getAttribute("class");
                if (outputWriterClass.isEmpty()) {
                    throw new IllegalArgumentException("<resultNameStrategy> element must contain a 'class' attribute");
                }
                try {
                    resultNameStrategy = (ResultNameStrategy)Class.forName(outputWriterClass).newInstance();
                    HashMap<String, String> settings = new HashMap<String, String>();
                    NodeList settingsNodeList = resultNameStrategyElement.getElementsByTagName("*");
                    for (int j = 0; j < settingsNodeList.getLength(); ++j) {
                        Element settingElement = (Element)settingsNodeList.item(j);
                        settings.put(settingElement.getNodeName(), this.placeholderResolver.resolveString(settingElement.getTextContent()));
                    }
                    resultNameStrategy.postConstruct(settings);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Exception instantiating " + outputWriterClass, e);
                }
            }
            default: {
                throw new IllegalStateException("More than 1 <resultNameStrategy> element found (" + resultNameStrategyNodeList.getLength() + ")");
            }
        }
        jmxTransExporter.resultNameStrategy = resultNameStrategy;
    }

    private void buildOutputWriters(Element rootElement, JmxTransExporter jmxTransExporter) {
        NodeList outputWriterNodeList = rootElement.getElementsByTagName("outputWriter");
        ArrayList<OutputWriter> outputWriters = new ArrayList<OutputWriter>();
        for (int i = 0; i < outputWriterNodeList.getLength(); ++i) {
            Element outputWriterElement = (Element)outputWriterNodeList.item(i);
            String outputWriterClass = outputWriterElement.getAttribute("class");
            if (outputWriterClass.isEmpty()) {
                throw new IllegalArgumentException("<outputWriter> element must contain a 'class' attribute");
            }
            try {
                OutputWriter outputWriter = (OutputWriter)Class.forName(outputWriterClass).newInstance();
                HashMap<String, String> settings = new HashMap<String, String>();
                NodeList settingsNodeList = outputWriterElement.getElementsByTagName("*");
                for (int j = 0; j < settingsNodeList.getLength(); ++j) {
                    Element settingElement = (Element)settingsNodeList.item(j);
                    settings.put(settingElement.getNodeName(), this.placeholderResolver.resolveString(settingElement.getTextContent()));
                }
                outputWriter = new OutputWriterCircuitBreakerDecorator(outputWriter);
                outputWriter.postConstruct(settings);
                outputWriters.add(outputWriter);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception instantiating " + outputWriterClass, e);
            }
        }
        switch (outputWriters.size()) {
            case 0: {
                this.logger.warning("No outputwriter defined.");
                break;
            }
            case 1: {
                jmxTransExporter.withOutputWriter((OutputWriter)outputWriters.get(0));
                break;
            }
            default: {
                jmxTransExporter.withOutputWriter(new OutputWritersChain(outputWriters));
            }
        }
    }
}

