/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util.logging;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class Logger {
    private final String name;
    public static Level level = Level.INFO;

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    @Nullable
    public static Level parseLevel(@Nullable String level, @Nullable Level defaultValue) {
        HashMap<String, Level> julLevelsByName = new HashMap<String, Level>(){
            {
                this.put("TRACE", Level.FINEST);
                this.put("FINEST", Level.FINEST);
                this.put("FINER", Level.FINER);
                this.put("FINE", Level.FINE);
                this.put("DEBUG", Level.FINE);
                this.put("INFO", Level.INFO);
                this.put("WARNING", Level.WARNING);
                this.put("WARN", Level.WARNING);
                this.put("SEVERE", Level.SEVERE);
            }
        };
        for (Map.Entry entry : julLevelsByName.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(level)) continue;
            return (Level)entry.getValue();
        }
        return defaultValue;
    }

    public Logger(String name) {
        this.name = name;
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        System.out.println(new Timestamp(System.currentTimeMillis()) + " " + level + " [" + Thread.currentThread().getName() + "] " + this.name + " - " + msg);
        if (thrown != null) {
            thrown.printStackTrace(System.out);
        }
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= Logger.level.intValue();
    }

    static {
        String level = System.getProperty(Logger.class.getName() + ".level", "INFO");
        Logger.level = Logger.parseLevel(level, Level.INFO);
    }
}

