/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.Preconditions2;
import org.jmxtrans.agent.util.logging.Logger;

public class Invocation {
    @Nullable
    protected final ObjectName objectName;
    @Nonnull
    protected final String operationName;
    @Nullable
    protected final String resultAlias;
    @Nonnull
    protected final Object[] params;
    @Nonnull
    protected final String[] signature;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Invocation(@Nullable String objectName, @Nonnull String operationName, @Nonnull Object[] params, @Nonnull String[] signature, @Nullable String resultAlias) {
        try {
            this.objectName = objectName == null ? null : new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid objectName '" + objectName + "'", e);
        }
        this.operationName = Preconditions2.checkNotNull(operationName, "operationName");
        this.params = Preconditions2.checkNotNull(params, "params");
        this.signature = Preconditions2.checkNotNull(signature, "signature");
        this.resultAlias = resultAlias;
    }

    public void invoke(MBeanServer mbeanServer, OutputWriter outputWriter) {
        Set<ObjectName> objectNames = mbeanServer.queryNames(this.objectName, null);
        for (ObjectName on : objectNames) {
            try {
                Object result = mbeanServer.invoke(on, this.operationName, this.params, this.signature);
                outputWriter.writeInvocationResult(this.resultAlias, result);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception invoking " + on + "#" + this.operationName + "(" + Arrays.toString(this.params) + ")", e);
            }
        }
    }

    public String toString() {
        return "Invocation{objectName=" + this.objectName + ", operationName='" + this.operationName + '\'' + ", resultAlias='" + this.resultAlias + '\'' + ", params=" + Arrays.toString(this.params) + ", signature=" + Arrays.toString(this.signature) + '}';
    }
}

