/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jmxtrans.agent.JmxTransExporter;
import org.jmxtrans.agent.JmxTransExporterBuilder;
import org.jmxtrans.agent.util.logging.Logger;

public class JmxTransAgent {
    private static Logger logger = Logger.getLogger(JmxTransAgent.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DIAGNOSTIC = Boolean.valueOf(System.getProperty(JmxTransAgent.class.getName() + ".diagnostic", "false"));

    public static void premain(String configFile, Instrumentation inst) {
        JmxTransAgent.dumpDiagnosticInfo();
        if (configFile == null || configFile.isEmpty()) {
            String msg = "JmxTransExporter configurationFile must be defined";
            logger.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
        try {
            JmxTransExporter jmxTransExporter = new JmxTransExporterBuilder().build(configFile);
            jmxTransExporter.start();
            logger.info("JmxTransAgent started with configuration '" + configFile + "'");
        }
        catch (Exception e) {
            String msg = "Exception loading JmxTransExporter from '" + configFile + "'";
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    public static void dumpDiagnosticInfo() {
        if (!DIAGNOSTIC) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (DIAGNOSTIC) {
                    String prefix = new Timestamp(System.currentTimeMillis()) + " [jmxtrans-agent] ";
                    System.out.println(prefix + "JMXTRANS-AGENT DIAGNOSTIC INFO");
                    System.out.println(prefix + "Logger level: " + Logger.level);
                    Set<ObjectInstance> objectInstances = ManagementFactory.getPlatformMBeanServer().queryMBeans(null, null);
                    ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
                    for (ObjectInstance objectInstance : objectInstances) {
                        objectNames.add(objectInstance.getObjectName());
                    }
                    Collections.sort(objectNames);
                    System.out.println(prefix + "ManagementFactory.getPlatformMBeanServer().queryMBeans(null, null)");
                    for (ObjectName objectName : objectNames) {
                        System.out.println(prefix + "\t" + objectName);
                    }
                    System.out.println(prefix + "ENF OF JMXTRANS-AGENT DIAGNOSING INFO");
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("jmxtrans-agent-diagnostic");
        thread.setDaemon(true);
        thread.start();
    }
}

