/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.logging.Logger;

public class RollingFileOutputWriter
extends AbstractOutputWriter {
    public static final String SETTING_FILE_NAME = "fileName";
    public static final String SETTING_FILE_NAME_DEFAULT_VALUE = "jmxtrans-agent.data";
    public static final String SETTING_MAX_FILE_SIZE = "maxFileSize";
    public static final long SETTING_MAX_FILE_SIZE_DEFAULT_VALUE = 10L;
    public static final String SETTING_MAX_BACKUP_INDEX = "maxBackupIndex";
    public static final int SETTING_MAX_BACKUP_INDEX_DEFAULT_VALUE = 5;
    private static DateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
    protected Writer temporaryFileWriter;
    protected File temporaryFile;
    protected File file = new File("jmxtrans-agent.data");
    protected long maxFileSize;
    protected int maxBackupIndex;

    @Override
    public synchronized void postConstruct(Map<String, String> settings) {
        super.postConstruct(settings);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        dfISO8601.setTimeZone(tz);
        this.file = new File(ConfigurationUtils.getString(settings, SETTING_FILE_NAME, SETTING_FILE_NAME_DEFAULT_VALUE));
        this.maxFileSize = ConfigurationUtils.getLong(settings, SETTING_MAX_FILE_SIZE, 10L);
        this.maxBackupIndex = ConfigurationUtils.getInt(settings, SETTING_MAX_BACKUP_INDEX, 5);
        if (this.maxFileSize > 10L || this.maxFileSize < 0L) {
            this.maxFileSize = 10L;
        }
        this.maxFileSize *= 1000000L;
        this.logger.log(this.getInfoLevel(), "RollingFileOutputWriter configured with file " + this.file.getAbsolutePath());
    }

    protected Writer getTemporaryFileWriter() throws IOException {
        if (this.temporaryFile == null) {
            this.temporaryFile = File.createTempFile("jmxtrans-agent-", ".data");
            this.temporaryFile.deleteOnExit();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Created temporary file " + this.temporaryFile.getAbsolutePath());
            }
            this.temporaryFileWriter = null;
        }
        if (this.temporaryFileWriter == null) {
            this.temporaryFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.temporaryFile, false), StandardCharsets.UTF_8));
        }
        return this.temporaryFileWriter;
    }

    @Override
    public void writeInvocationResult(String invocationName, Object value) throws IOException {
        this.writeQueryResult(invocationName, null, value);
    }

    @Override
    public synchronized void writeQueryResult(@Nonnull String name, @Nullable String type, @Nullable Object value) throws IOException {
        try {
            this.getTemporaryFileWriter().write("[" + dfISO8601.format(Calendar.getInstance().getTime()) + "] " + name + " " + value + "\n");
        }
        catch (IOException e) {
            this.releaseTemporaryWriter();
            throw e;
        }
    }

    protected void releaseTemporaryWriter() {
        boolean deleted;
        try {
            IoUtils.closeQuietly(this.getTemporaryFileWriter());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.temporaryFile != null && !(deleted = this.temporaryFile.delete())) {
            this.logger.warning("Silently ignore failure to delete " + this.temporaryFile);
        }
        this.temporaryFile = null;
    }

    @Override
    public synchronized void postCollect() throws IOException {
        try {
            this.getTemporaryFileWriter().close();
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Overwrite " + this.file.getAbsolutePath() + " by " + this.temporaryFile.getAbsolutePath());
            }
            IoUtils.appendToFile(this.temporaryFile, this.file, this.maxFileSize, this.maxBackupIndex);
        }
        finally {
            this.temporaryFileWriter = null;
        }
    }

    public static class IoUtils {
        private static final Logger LOGGER = Logger.getLogger(IoUtils.class.getName());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doCopySmallFile(File source, File destination, boolean append) throws IOException {
            boolean renamed;
            if (destination.exists() && destination.isDirectory()) {
                throw new IOException("Can not copy file, destination is a directory: " + destination.getAbsolutePath());
            }
            if (!destination.exists() && (renamed = source.renameTo(destination))) {
                return;
            }
            InputStream fis = null;
            FileOutputStream fos = null;
            Closeable input = null;
            Closeable output = null;
            long initialSize = destination.length();
            try {
                fos = new FileOutputStream(destination, append);
                if (append) {
                    fos.write("\n".getBytes(StandardCharsets.UTF_8));
                }
                fos.write(Files.readAllBytes(Paths.get(source.getAbsolutePath(), new String[0])));
            }
            finally {
                IoUtils.closeQuietly(output);
                IoUtils.closeQuietly(input);
                IoUtils.closeQuietly(fis);
                IoUtils.closeQuietly(fos);
            }
            if (!append && destination.length() != source.length()) {
                throw new IOException("Failed to copy content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + "). isAppend? " + append);
            }
            if (append && destination.length() <= initialSize) {
                throw new IOException("Failed to append content from '" + source + "' (" + source.length() + "bytes) to '" + destination + "' (" + destination.length() + "). isAppend? " + append);
            }
        }

        public static void closeQuietly(Closeable closeable) {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void closeQuietly(@Nullable Writer writer) {
            if (writer == null) {
                return;
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static void closeQuietly(InputStream inputStream) {
            if (inputStream == null) {
                return;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void appendToFile(File source, File destination, long maxFileSize, int maxBackupIndex) throws IOException {
            boolean destinationExists = IoUtils.validateDestinationFile(source, destination, maxFileSize, maxBackupIndex);
            if (destinationExists) {
                IoUtils.doCopySmallFile(source, destination, true);
            } else {
                boolean renamed = source.renameTo(destination);
                if (!renamed) {
                    IoUtils.doCopySmallFile(source, destination, false);
                }
            }
        }

        private static boolean validateDestinationFile(File source, File destination, long maxFileSize, int maxBackupIndex) throws IOException {
            if (!destination.exists() || destination.isDirectory()) {
                return false;
            }
            long totalLengthAfterAppending = destination.length() + source.length();
            if (totalLengthAfterAppending > maxFileSize) {
                IoUtils.rollFiles(destination, maxBackupIndex);
                return false;
            }
            return true;
        }

        private static void rollFiles(File destination, int maxBackupIndex) throws IOException {
            for (int i = maxBackupIndex - 1; i >= 0; --i) {
                String path = destination.getAbsolutePath();
                path = i == 0 ? path : path + "." + i;
                File f = new File(path);
                if (!f.exists()) continue;
                File fNext = new File(destination + "." + (i + 1));
                IoUtils.doCopySmallFile(f, fNext, false);
            }
            boolean deleted = destination.delete();
            if (!deleted) {
                LOGGER.warning("Failure to delete file " + destination);
            }
        }
    }
}

