/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent.util;

import javax.annotation.Nullable;

public class Preconditions2 {
    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNotNull(T reference, @Nullable String message) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException(message == null ? "" : message);
        }
        return reference;
    }

    public static String checkNotEmpty(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.isEmpty()) {
            throw new IllegalArgumentException("Can not be empty");
        }
        return str;
    }

    public static void checkArgument(boolean expression) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable String msg) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkArgument(boolean expression, @Nullable String msgFormat, Object ... msgArgs) throws IllegalArgumentException {
        if (!expression) {
            if (msgFormat == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format(msgFormat, msgArgs));
        }
    }
}

