/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.util.ConfigurationUtils;
import org.jmxtrans.agent.util.logging.Logger;

public abstract class AbstractOutputWriter
implements OutputWriter {
    public static final String SETTING_LOG_LEVEL = "logLevel";
    public static final String SETTING_LOG_LEVEL_DEFAULT_VALUE = "INFO";
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Level debugLevel = Level.FINE;
    private Level traceLevel = Level.FINER;
    private Level infoLevel = Level.INFO;

    @Override
    public void postConstruct(@Nonnull Map<String, String> settings) {
        String logLevel = ConfigurationUtils.getString(settings, SETTING_LOG_LEVEL, SETTING_LOG_LEVEL_DEFAULT_VALUE);
        if ("TRACE".equalsIgnoreCase(logLevel) || "FINEST".equalsIgnoreCase(logLevel)) {
            this.infoLevel = Level.INFO;
            this.debugLevel = Level.INFO;
            this.traceLevel = Level.INFO;
        } else if ("DEBUG".equalsIgnoreCase(logLevel) || "FINER".equalsIgnoreCase(logLevel) || "FINE".equalsIgnoreCase(logLevel)) {
            this.infoLevel = Level.INFO;
            this.debugLevel = Level.INFO;
            this.traceLevel = Level.FINE;
        } else if ("WARN".equalsIgnoreCase(logLevel)) {
            this.infoLevel = Level.FINE;
            this.debugLevel = Level.FINE;
            this.traceLevel = Level.FINE;
        } else {
            this.infoLevel = Level.INFO;
            this.debugLevel = Level.FINE;
            this.traceLevel = Level.FINER;
        }
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public void postCollect() throws IOException {
    }

    @Override
    public void preCollect() throws IOException {
    }

    @Override
    public abstract void writeInvocationResult(@Nonnull String var1, @Nullable Object var2) throws IOException;

    @Override
    public abstract void writeQueryResult(@Nonnull String var1, @Nullable String var2, @Nullable Object var3) throws IOException;

    @Nonnull
    protected Level getDebugLevel() {
        return this.debugLevel;
    }

    @Nonnull
    protected Level getTraceLevel() {
        return this.traceLevel;
    }

    @Nonnull
    protected Level getInfoLevel() {
        return this.infoLevel;
    }
}

