/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.agent.AbstractOutputWriter;
import org.jmxtrans.agent.OutputWriter;
import org.jmxtrans.agent.QueryResult;
import org.jmxtrans.agent.util.collect.EvictingQueue;

public class PerMinuteSummarizerOutputWriter
extends AbstractOutputWriter
implements OutputWriter {
    protected OutputWriter delegate;
    protected Map<String, Queue<QueryResult>> previousQueryResultsByMetricName = new HashMap<String, Queue<QueryResult>>();

    public PerMinuteSummarizerOutputWriter() {
    }

    public PerMinuteSummarizerOutputWriter(OutputWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void writeInvocationResult(@Nonnull String invocationName, @Nullable Object value) throws IOException {
        this.delegate.writeInvocationResult(invocationName, value);
    }

    @Override
    public void writeQueryResult(@Nonnull String metricName, @Nullable String metricType, @Nullable Object value) throws IOException {
        QueryResult currentResult = new QueryResult(metricName, metricType, value, System.currentTimeMillis());
        if ("counter".equals(currentResult.getType())) {
            QueryResult previousResult = this.getPreviousQueryResult(currentResult);
            this.storeQueryResult(currentResult);
            QueryResult newCurrentResult = this.perMinute(currentResult, previousResult);
            if (this.logger.isLoggable(this.getDebugLevel())) {
                this.logger.log(this.getDebugLevel(), "Metric " + currentResult.getName() + " is a counter " + "current=" + currentResult + ", " + "previous=" + previousResult + ", " + "newCurrent.value=" + newCurrentResult.getValue());
            }
            this.delegate.writeQueryResult(newCurrentResult.getName(), newCurrentResult.getType(), newCurrentResult.getValue());
        } else {
            if (this.logger.isLoggable(this.getTraceLevel())) {
                this.logger.log(this.getTraceLevel(), "Metric " + currentResult.getName() + " is a NOT a counter");
            }
            this.delegate.writeQueryResult(metricName, metricType, value);
        }
    }

    protected void storeQueryResult(@Nullable QueryResult currentResult) {
        if (currentResult == null) {
            return;
        }
        Queue<QueryResult> queue = this.previousQueryResultsByMetricName.get(currentResult.getName());
        if (queue == null) {
            queue = new EvictingQueue<QueryResult>(3);
            this.previousQueryResultsByMetricName.put(currentResult.getName(), queue);
        }
        queue.add(currentResult);
    }

    @Nullable
    protected QueryResult getPreviousQueryResult(@Nonnull QueryResult currentResult) {
        Queue<QueryResult> queue = this.previousQueryResultsByMetricName.get(currentResult.getName());
        if (queue == null) {
            return null;
        }
        long targetTimeInMillis = currentResult.getEpochInMillis() - TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
        long closestDistanceToTarget = Long.MAX_VALUE;
        QueryResult closestQueryResultToTarget = null;
        for (QueryResult queryResult : queue) {
            long distanceToTarget;
            if (queryResult.isValueGreaterThan(currentResult) || (distanceToTarget = Math.abs(queryResult.getEpochInMillis() - targetTimeInMillis)) >= closestDistanceToTarget) continue;
            closestQueryResultToTarget = queryResult;
            closestDistanceToTarget = distanceToTarget;
        }
        return closestQueryResultToTarget;
    }

    @Nonnull
    public QueryResult perMinute(@Nonnull QueryResult currentResult, @Nullable QueryResult previousResult) {
        Number newCurrentValue;
        BigDecimal valueDelta;
        Number previousValue;
        if (!(currentResult.getValue() instanceof Number)) {
            if (this.logger.isLoggable(this.getInfoLevel())) {
                this.logger.log(this.getInfoLevel(), "Current value is not a number, cannot calculate derivative " + currentResult);
            }
            return currentResult;
        }
        if (previousResult == null) {
            if (this.logger.isLoggable(this.getTraceLevel())) {
                this.logger.log(this.getTraceLevel(), "No previous value found for metric '" + currentResult.getName() + "'");
            }
            return new QueryResult(currentResult.getName(), "gauge", currentResult.getValue(), currentResult.getEpochInMillis());
        }
        if (!(previousResult.getValue() instanceof Number)) {
            if (this.logger.isLoggable(this.getInfoLevel())) {
                this.logger.log(this.getInfoLevel(), "previous value is not a number, cannot calculate derivative " + previousResult);
            }
            return currentResult;
        }
        BigDecimal durationInMillis = new BigDecimal(currentResult.getEpochInMillis() - previousResult.getEpochInMillis());
        Number currentValue = (Number)currentResult.getValue();
        if (((Comparable)((Object)currentValue)).compareTo(previousValue = (Number)previousResult.getValue()) < 0) {
            if (this.logger.isLoggable(this.getTraceLevel())) {
                this.logger.log(this.getTraceLevel(), "Previous value is greater than current value for metric '" + currentResult.getName() + "', ignore it");
            }
            return new QueryResult(currentResult.getName(), "gauge", currentResult.getValue(), currentResult.getEpochInMillis());
        }
        if (currentValue instanceof Long) {
            valueDelta = new BigDecimal(currentValue.longValue() - previousValue.longValue());
        } else if (currentValue instanceof Integer) {
            valueDelta = new BigDecimal(currentValue.intValue() - previousValue.intValue());
        } else if (currentValue instanceof Float) {
            valueDelta = new BigDecimal(currentValue.floatValue() - previousValue.floatValue());
        } else if (currentValue instanceof Double) {
            valueDelta = new BigDecimal(currentValue.doubleValue() - previousValue.doubleValue());
        } else {
            if (this.logger.isLoggable(this.getInfoLevel())) {
                this.logger.log(this.getInfoLevel(), "unsupported value type '" + currentValue.getClass() + ", cannot calculate perMinute " + currentResult);
            }
            return currentResult;
        }
        BigDecimal perMinute = valueDelta.movePointRight(3).multiply(new BigDecimal(60)).divide(durationInMillis, RoundingMode.HALF_UP);
        if (currentValue instanceof Long) {
            newCurrentValue = perMinute.longValue();
        } else if (currentValue instanceof Integer) {
            newCurrentValue = perMinute.intValue();
        } else if (currentValue instanceof Float) {
            newCurrentValue = Float.valueOf(perMinute.floatValue());
        } else if (currentValue instanceof Double) {
            newCurrentValue = perMinute.doubleValue();
        } else {
            if (this.logger.isLoggable(this.getInfoLevel())) {
                this.logger.log(this.getInfoLevel(), "Illegal state " + previousResult);
            }
            return currentResult;
        }
        return new QueryResult(currentResult.getName(), "gauge", newCurrentValue, currentResult.getEpochInMillis());
    }

    @Override
    public void postConstruct(@Nonnull Map<String, String> settings) {
        super.postConstruct(settings);
        this.delegate.postConstruct(settings);
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
        this.delegate.preDestroy();
    }

    @Override
    public void postCollect() throws IOException {
        super.postCollect();
        this.delegate.postCollect();
    }

    @Override
    public void preCollect() throws IOException {
        super.preCollect();
        this.delegate.preCollect();
    }

    public void setDelegate(OutputWriter delegate) {
        this.delegate = delegate;
    }
}

