/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jmxtrans.agent.ExpressionLanguageEngineImpl;
import org.jmxtrans.agent.JmxTransConfigurationXmlLoader;
import org.jmxtrans.agent.JmxTransExporter;
import org.jmxtrans.agent.properties.NoPropertiesSourcePropertiesLoader;
import org.jmxtrans.agent.properties.PropertiesLoader;
import org.jmxtrans.agent.properties.ResourcePropertiesLoader;
import org.jmxtrans.agent.util.StringUtils2;
import org.jmxtrans.agent.util.io.Resource;
import org.jmxtrans.agent.util.io.ResourceFactory;
import org.jmxtrans.agent.util.logging.Logger;

public class JmxTransAgent {
    private static Logger logger = Logger.getLogger(JmxTransAgent.class.getName());
    private static final String PROPERTIES_SYSTEM_PROPERTY_NAME = "jmxtrans.agent.properties.file";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DIAGNOSTIC = Boolean.valueOf(System.getProperty(JmxTransAgent.class.getName() + ".diagnostic", "false"));

    private JmxTransAgent() {
    }

    public static void agentmain(String configFile, Instrumentation inst) {
        JmxTransAgent.initializeAgent(configFile);
    }

    public static void premain(final String configFile, Instrumentation inst) {
        final int delayInSecs = Integer.parseInt(System.getProperty("jmxtrans.agent.premain.delay", "0"));
        final boolean waitForCustomMBeanServer = Boolean.parseBoolean(System.getProperty("jmxtrans.agent.premain.waitForCustomMBeanServer"));
        final int timeoutInSeconds = Integer.parseInt(System.getProperty("jmxtrans.agent.premain.waitForCustomMBeanServer.timeoutInSeconds", "120"));
        if (delayInSecs > 0) {
            logger.info("jmxtrans agent initialization delayed by " + delayInSecs + " seconds");
            new Thread("jmxtrans-agent-delayed-starter-" + delayInSecs + "secs"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delayInSecs * 1000);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return;
                    }
                    if (waitForCustomMBeanServer) {
                        logger.info("jmxtrans agent initialization delayed waiting for MBeanServer");
                        if (!JmxTransAgent.waitForCustomMBeanServer(timeoutInSeconds)) {
                            return;
                        }
                    }
                    JmxTransAgent.initializeAgent(configFile);
                }
            }.start();
        } else if (waitForCustomMBeanServer) {
            logger.info("jmxtrans agent initialization delayed waiting for custom MBeanServer");
            new Thread("jmxtrans-agent-delayed-starter-waitForCustomMBeanServer"){

                @Override
                public void run() {
                    if (!JmxTransAgent.waitForCustomMBeanServer(timeoutInSeconds)) {
                        return;
                    }
                    JmxTransAgent.initializeAgent(configFile);
                }
            }.start();
        } else {
            JmxTransAgent.initializeAgent(configFile);
        }
    }

    public static void main(String[] args) {
        Logger.out.println(JmxTransAgent.getVersionInfo());
    }

    @Nonnull
    public static String getVersionInfo() {
        Package pkg = JmxTransAgent.class.getPackage();
        if (pkg == null) {
            return "jmxtrans-agent";
        }
        return pkg.getImplementationTitle() + ": " + pkg.getImplementationVersion();
    }

    private static void initializeAgent(String configPath) {
        JmxTransAgent.dumpDiagnosticInfo();
        if (configPath == null || configPath.isEmpty()) {
            String msg = "JmxTransExporter configurationFile must be defined";
            logger.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
        try {
            logger.info("Starting '" + JmxTransAgent.getVersionInfo() + "' with configuration '" + configPath + "'...");
            PropertiesLoader propertiesLoader = JmxTransAgent.createPropertiesLoader();
            Resource configuration = ResourceFactory.newResource(configPath);
            ExpressionLanguageEngineImpl expressionLanguageEngine = new ExpressionLanguageEngineImpl();
            JmxTransConfigurationXmlLoader configurationLoader = new JmxTransConfigurationXmlLoader(configuration, propertiesLoader, expressionLanguageEngine);
            JmxTransExporter jmxTransExporter = new JmxTransExporter(configurationLoader);
            jmxTransExporter.start();
            logger.info("JmxTransAgent started with configuration '" + configPath + "'");
        }
        catch (Exception e) {
            String msg = "Exception loading JmxTransExporter from '" + configPath + "'";
            logger.log(Level.SEVERE, msg, e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static PropertiesLoader createPropertiesLoader() {
        String propertiesFile = System.getProperty(PROPERTIES_SYSTEM_PROPERTY_NAME);
        PropertiesLoader result = StringUtils2.isNullOrEmpty(propertiesFile) ? new NoPropertiesSourcePropertiesLoader() : new ResourcePropertiesLoader(propertiesFile);
        logger.info("PropertiesLoader: " + result.getDescription());
        return result;
    }

    public static void dumpDiagnosticInfo() {
        if (!DIAGNOSTIC) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (DIAGNOSTIC) {
                    String prefix = new Timestamp(System.currentTimeMillis()) + " [jmxtrans-agent] ";
                    Logger.out.println(prefix + "JMXTRANS-AGENT DIAGNOSTIC INFO");
                    Logger.out.println(prefix + "Logger level: " + Logger.level);
                    Set<ObjectInstance> objectInstances = ManagementFactory.getPlatformMBeanServer().queryMBeans(null, null);
                    ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
                    for (ObjectInstance objectInstance : objectInstances) {
                        objectNames.add(objectInstance.getObjectName());
                    }
                    Collections.sort(objectNames);
                    Logger.out.println(prefix + "ManagementFactory.getPlatformMBeanServer().queryMBeans(null, null)");
                    for (ObjectName objectName : objectNames) {
                        Logger.out.println(prefix + "\t" + objectName);
                    }
                    Logger.out.println(prefix + "ENF OF JMXTRANS-AGENT DIAGNOSING INFO");
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("jmxtrans-agent-diagnostic");
        thread.setDaemon(true);
        thread.start();
    }

    private static boolean waitForCustomMBeanServer(int timeoutInSeconds) {
        long startInMs = System.currentTimeMillis();
        while (!JmxTransAgent.isCustomMBeanServerConfigured() && JmxTransAgent.secondsSince(startInMs) < (long)timeoutInSeconds) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
        }
        if (JmxTransAgent.secondsSince(startInMs) >= (long)timeoutInSeconds) {
            logger.info("jmxagent initialization timed out waiting for custom MBeanServer");
            return false;
        }
        return true;
    }

    private static boolean isCustomMBeanServerConfigured() {
        return System.getProperty("javax.management.builder.initial") != null;
    }

    private static long secondsSince(long startInMs) {
        return (System.currentTimeMillis() - startInMs) / 1000L;
    }
}

